<?php

class CusminDashboardWidgetsApplier
{
    //Original widgets
    private $widgets;

    //Custom definitions for custom widgets
    private $myWidgets;

    public function __construct($widgets = array(), $myWidgets)
    {
        $this->widgets = $widgets;
        $this->myWidgets = $myWidgets;
    }

    public function applyCustomWidgets(){
        foreach ($this->myWidgets as $w) {
            $title = isset($w['title'])?$w['title']:'';
            $template = isset($w['template'])?$w['template']:'';
            $content = isset($w['content'])?$w['content']:'';
            $url = isset($w['url'])?$w['url']:'';
            $embed = isset($w['embed'])?$w['embed']:'';

            if($template){
                switch($template){
                    case "youtube":
                        $content = $this->prepareYoutubeContent($url);
                        break;
                    case 'vimeo':
                        $content = $this->prepareVimeoContent($url);
                        break;
                    case 'twitter':
                        $content = $this->prepareTwitterContent($embed);
                        break;
                    case 'facebook':
                        $content = $this->prepareFacebookContent($embed);
                        break;
                    case 'pinterest':
                        $content = $this->preparePinterest($url);
                        break;
                    case 'gcalendar':
                        $content = $this->prepareGoogleCalendar($embed);
                        break;
                    case 'instagram':
                        $content = $this->prepareInstagramContent($embed);
                        break;
                    case 'rss':
                        $content = $this->prepareRSSContent($url);
                        break;
                    case 'weather':
                        $content = $embed;
                        break;
                }
            }
            $content = do_shortcode($content);
            //add_meta_box( 'my_dashboard_widget', 'My Widget Name', 'my_dashboard_widget_function', 'dashboard', 'side', 'high' );
            add_meta_box(sanitize_title('cusmin_dwidget_' . $title), $title, array(&$this, 'add_dashboard_widget'),  'dashboard', 'column4', 'default' , $content);
            //wp_add_dashboard_widget(sanitize_title('cusmin_dwidget_' . $title), $title, array(&$this, 'add_dashboard_widget'), null, $content);

            /*$id = get_current_user_id(); //we need to know who we're updating
            $meta_value = array(
                'normal'  => 'custom_help_widget',
                'side'    => 'conditional_help_widget',
                'column3' => 'override_help_widget',
                'column4' => '',
            );
            update_user_meta( $id, 'meta-box-order_dashboard', $meta_value ); */
            //}
        }
    }

    public function hideOriginalWidgets(){
        $widgets = $this->widgets;
        //TODO: Make it more general, instead of using normal, side, loop through settings and use slugs
        foreach (array('normal', 'side') as $type) {
            if (isset($widgets[$type])) {
                foreach ((array) $widgets[$type] as $slug) {
                    if ($slug == 'welcome_panel') {
                        remove_action('welcome_panel', 'wp_welcome_panel');
                    } else {
                        remove_meta_box($slug, 'dashboard', $type);
                    }
                }
            }
        }
    }

    public function add_dashboard_widget($var, $args)
    {
        echo $args['args'];
    }

    private function prepareYoutubeContent($url, $height = '350'){
        //TODO: Make it work with WP embed
        //return do_shortcode('<div>[recent-posts]</div>');
        //return do_shortcode('<div>[embed]'.$url.'[/embed]</div>');

        $url = trim($url);
        $code = '';
        //regular url
        if(strpos($url, 'youtube.com/watch') !== false){
            $parts = parse_url($url);
            parse_str($parts['query'], $query);
            $code = $query['v'];
        }
        //iframe or url from iframe
        else if(strpos($url, 'youtube.com/embed/') !== false){
            $parts = explode('/embed/', $url);
            $url = $parts[1];
            $parts = explode('"', $url);
            $code = $parts[0];
        }else{
            //last change, try only code case
            $code = $url;
        }
        $iframe =  '<iframe width="100%" height="'.$height.'px" src="https://www.youtube.com/embed/'.$code.'" frameborder="0" allowfullscreen></iframe>';
        return '<div class="youtube-widget"  style="text-align: center">'.$iframe.'</div>';
    }
    private function prepareVimeoContent($url, $height = '350'){
        $url = trim($url);
        $code = '';
        //iframe or url from iframe
        if(strpos($url, '<iframe') !== false){
            $parts = explode('vimeo.com/video/', $url);
            $url = $parts[1];
            $parts = explode('"', $url);
            $code = $parts[0];
        }
        else if(strpos($url, 'player.vimeo.com/') !== false){
            $parts = explode('/video/', $url);
            $url = $parts[1];
            $parts = explode('?', $url);
            $code = $parts[0];
        }
        //regular url
        else if(strpos($url, 'vimeo.com/') !== false){
            $parts = explode('vimeo.com/', $url);
            $code = $parts[1];
        }
        //$code = $url;
        $iframe = '<iframe src="https://player.vimeo.com/video/'.$code.'" width="100%" height="'.$height.'px" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
        return '<div class="vimeo-widget"  style="text-align: center">'.$iframe.'</div>';
    }

    private function prepareTwitterContent($embed){
        $embed = $this->changeAttribute('width', '100%', $embed);
        return '<div class="twitter-widget"  style="text-align: center">'.$embed.'</div>';
    }

    private function prepareRSSContent($url){
        $rss = fetch_feed($url);
        $feed = '';
        $perPage = 3;

        if (!is_wp_error( $rss ) ) :
            $maxitems = $rss->get_item_quantity(100);
            $rss_items = $rss->get_items(0, $maxitems);

            if ($rss_items):
                $feed .="<div class='rss-widget' data-page='1' data-per-page='$perPage'>";
                $feed .= "<ul>\n";
                $counter = 1;
                foreach ( $rss_items as $item ) :
                    $image = '';
                    $hide = $counter > 3;
                    if ($enclosure = $item->get_enclosure())
                    {
                        $image = '<img src="'.$enclosure->get_link().'" />';
                    }
                    $feed.= sprintf('<li class="'.($hide?'hiddens':'').'" ><h2><a href="%s" target="_blank">%s</a></h2><div class="content"><div class="image"><a href="%s" target="_blank">%s</a></div>%s</div></li>',$item->get_permalink(),$item->get_title(),$item->get_permalink(),$image,$item->get_description() );
                    $counter++;
                endforeach;
                $feed .= "</ul>\n";
                $feed .="<div class='controls'><a class='left previous'>&lt;&lt; previous</a><a class='right next'>next &gt;&gt;</a></div>";
                $feed .="</div>";
            endif;
        endif;

        return $feed;
    }

    private function prepareFacebookContent($embed){
        //$embed = $this->changeAttribute('width', '100%', $embed);
        return '<div class="facebook-widget" style="text-align: center">'.$embed.'</div>';
    }

    private function prepareInstagramContent($embed){
        return '<div class="instagram-widget" style="text-align: center">'.$embed.'</div>';
    }

    private function preparePinterest($url){
        //TYPE: PIN
        $iframe = '';
        if(strpos($url, '/pin/') !== false){
            $iframe = '<a data-pin-do="embedPin" data-pin-width="large" href="'.$url.'"></a>';
        }
        else{
            $parts = explode('pinterest.com/', $url);
            //TYPE:BOARD
            if(substr_count($parts[1],'/') > 1){
                $iframe = '<a data-pin-do="embedBoard" data-pin-board-width="1000px" data-pin-scale-height="450px" data-pin-scale-width="100" href="'.$url.'"></a>';
            }
            //TYPE: PROFILE
            else{
                $iframe = '<a data-pin-do="embedUser"  data-pin-board-width="1000px" data-pin-scale-height="450px" data-pin-scale-width="100" href="'.$url.'"></a>';
            }
        }

        return '<div class="pinterest-widget" style="text-align: center">' . $iframe . '</div>';;
    }

    private function prepareGoogleCalendar($embed){
        $embed = $this->changeAttribute('width', '100%', $embed);
        $embed = $this->changeAttribute('height', '450px', $embed);
        return '<div class="gcalendar-widget">'.$embed.'</div>';
    }

    private function changeAttribute($name, $value, $embed){
        $embed = preg_replace('/'.$name.'=\"(.*?)\"/', $name.'="'.$value.'"', $embed);
        $embed = preg_replace('/'.$name.'=\'(.*?)\'/', $name.'="'.$value.'"', $embed);
        return $embed;
    }
}

