<?php

class Cusmin_OptionsPage
{

    private $plugin_name;
    private $version;

    public function __construct($plugin_name, $version)
    {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    public function render()
    {
        if(isset($_GET['debug']) && $_GET['debug'] == 'true') {
            ?>
            <p style="font-weight: bold;border: 1px solid red;border-radius: 7px;padding: 10px;margin-right: 20px;">You are running Cusmin in debugging mode. If you're experiencing any issues, please do everything to reproduce the issue or wait until the issue is present on screen. After that, please click on "Send logs" button to report the issue to Cusmin support. We will then try to fix it if it's something on our side or at least help you to identify the source of the problem. Feel free also to contact us if the issue persists. Thank you!</p>
            <?php
        }

        ?><h2><?php echo esc_html(get_admin_page_title()); ?></h2>
        <textarea id="cusmin-logs" style="height: 100px;margin: 20px 0; display: none; width: 50%;"></textarea>
        <form method="post" action="options.php">
        <?php

        settings_fields('cusmin_options');

        Cusmin_Views::show('cusmin-admin');

        do_settings_sections($this->plugin_name);

        //submit_button( 'Save Settings' );

        ?></form><?php

    } // options_page()
}