<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       http://example.com
 * @since      1.0.0
 *
 * @package    Cusmin
 * @subpackage Cusmin/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Cusmin
 * @subpackage Cusmin/public
 * @author     Your Name <email@example.com>
 */
class Cusmin_Public
{

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $cusmin The ID of this plugin.
     */
    private $cusmin;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $version The current version of this plugin.
     */
    private $version;

    private $options;

    /**
     * @var CusminApplier
     */
    private $applier;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string $cusmin The name of the plugin.
     * @param      string $version The version of this plugin.
     */
    public function __construct($cusmin, $version)
    {

        $this->cusmin = $cusmin;
        $this->version = $version;
        $this->options = new CusminOptions();
    }

    /**
     * Register the stylesheets for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function enqueue_styles()
    {

        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Cusmin_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Cusmin_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */

        //TODO: Test this more
        if(is_admin_bar_showing() && CusminOptions::isPublicCSSSet()){
            //TODO: Don't use FA in admin panel if no settings are set to use it
            $this->enqueue_style('fa', '../public/css/fa/css/font-awesome.min.css');
            $this->enqueue_style('material-icons', '../public/css/mi/css/material.min.css');
            $this->enqueue_style('admin-panel', '../admin/bundle/css/cusmin.admin.panel.min.css');
        }

       //TODO: Check order, put near head tag ending if possible, refactor
        if(CusminOptions::isPublicCSSSet() || is_admin_bar_showing()) {
            if(CUSMIN_SCRIPT_TYPE === 'url') {
                wp_enqueue_style($this->cusmin, get_site_url() . '?cusmin-script=public.css', array(), CusminOptions::getId(), 'all');
            } else {
                wp_enqueue_style($this->cusmin, plugin_dir_url(__FILE__) . 'cusmin-script.php', array(), CusminOptions::getId(), 'all');
            }
        }
    }


    /**
     * WP API facing method
     * @param $slug
     * @param $location
     * @param array $dependencies
     */
    private function enqueue_style($slug, $location, $dependencies = array())
    {
        wp_enqueue_style($this->cusmin . '-'. $slug, plugin_dir_url(__FILE__) . $location, $dependencies, $this->version, 'all');
    }

    /**
     * Register the JavaScript for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function enqueue_scripts()
    {

        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Cusmin_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Cusmin_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
    }

    public function on_footer(){
        if(CusminOptions::isPublicJSSet()) {
            if(CUSMIN_SCRIPT_TYPE === 'url') {
                wp_enqueue_script($this->cusmin, get_site_url() . '?cusmin-script=public.js', array('jquery'), CusminOptions::getId(), false);
            }else {
                wp_enqueue_script($this->cusmin, plugin_dir_url(__FILE__) . 'cusmin-script.php?type=js', array('jquery'), CusminOptions::getId(), false);
            }

        }

        if(!$this->applier){
            $this->loadCustomizations();
        };

        if($this->applier->setting_137()){
            echo $this->wrapGACode($this->applier->setting_137());
        }
    }

    protected function wrapGACode($code){
        return
            "<script type='text/javascript'>(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){".
            "(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),".
            "m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)".
            "})(window,document,'script','//www.google-analytics.com/analytics.js','ga');".
            "ga('create', '".$code."', 'auto');".
            "ga('send', 'pageview');</script>";
    }

    private function public_user_logged_in(){
        //TODO: Check if we need to remove disabling cusmin scripts on site pages
        /*if($this->applier->setting_8()){
            //TODO: Implement script application on site pages
        }*/
        $this->applyCSS();
        $this->applyJS();
    }

    private function public_user_logged_out(){

    }

    //TODO: Implement after implementing and loading admin scripts correctly
    private function applyCSS()
    {
        //TBD
    }

    //TODO: Implement after implementing and loading admin scripts correctly
    private function applyJS()
    {
        //TBD
    }

    //hook
    public function cusmin_show_admin_bar($bool)
    {
        if(is_user_logged_in()){
            if($this->applier){
                try{
                    //Disable admin bar on front end for specific pages
                    $url=$_SERVER['REQUEST_URI'];

                    //Disable for BuddyPress customizer page
                    if(strpos($url, 'bp_customizer=email') && strpos($url, 'post_type=bp-email')){
                        return false;
                    }
                }catch (\Exception $e){};

                return $this->applier->setting_9();
            }
        }else{
            if(!$this->applier){
                $customizations = $this->options->getPublicCustomizations();
                if(!empty($customizations['php'])){
                    $this->applier = new CusminApplier($customizations['php']);
                    //if flag for showing admin bar publicly is enabled
                    if($this->applier->setting_138()){
                        //add cusmin class to body
                        add_filter('body_class', function (array $classes) {
                            $classes[] = 'cusmin';
                            return $classes;
                        });
                        add_filter( 'show_admin_bar', '__return_true', 99999 );
                        return true;
                    }
                }
            }
        }
        return $bool;
    }

    public function admin_bar_menu()
    {
        //On public pages
        if(!is_admin() && !is_user_logged_in()){
            if(!$this->applier){
                $this->loadCustomizations();
            }
            if($this->applier->setting_138()){
                //Apply Cusmin AB customizations publicly for logged out users
                $this->options->setAdminBar();
                if(!$this->applier->setting_156()){
                    $this->options->adminBarApplyPublicCustomizations();
                }
            }
        }
    }

    public function add_admin_bar_items($wp_admin_bar){
        if(!is_admin() && !is_user_logged_in()){
            if(!$this->applier){
                $this->loadCustomizations();
            }
            if($this->applier->setting_177()){
                $args = array(
                    'id' => 'custom-public-register-button',
                    'parent' => 'top-secondary',
                    'title' => '<span style="margin-top: 3px;" class="ab-icon dashicons dashicons-id"></span>' . _( 'Register' ),
                    'href' => wp_registration_url(),
                    'meta' => array(
                        'class' => 'custom-button-class'
                    )
                );

                if($this->applier->setting_178()){
                    $args['title'] = _( 'Register' );
                }

                $wp_admin_bar->add_node($args);
            }
            if($this->applier->setting_176()){
                $args = array(
                    'id' => 'custom-public-login-button',
                    'parent' => 'top-secondary',
                    'title' => '<span style="margin-top: 3px;" class="ab-icon dashicons dashicons-admin-network"></span>' . _( 'Login' ),
                    'href' => wp_login_url(),
                    'meta' => array(
                        'class' => 'custom-button-class'
                    )
                );
                if($this->applier->setting_178()){
                    $args['title'] = _( 'Login' );
                }
                $wp_admin_bar->add_node($args);
            }
        }
    }

    private function loadCustomizations()
    {
        $customizations = $this->options->getCurrentUserCustomizations();
        $php = $customizations['php'];
        $this->applier = new CusminApplier($php);
    }

    private function register_settings(){
        $this->loadCustomizations();
    }

    public final function public_init(){
        if(is_admin()){
            return false;
        }
        if(is_user_logged_in()){
            $this->register_settings();
            $this->public_user_logged_in();
        }else{
            //$this->public_user_logged_out();
        }
    }

    public function ajax_public_admin_bar(){
        if (!$this->is_ajax_call_get_public_admin_bar()) {
            return false;
        }
        global $wp_admin_bar;
        $nodes = $wp_admin_bar->get_nodes();
        echo '<public-admin-bar>' . json_encode($nodes) . '</public-admin-bar>';
        die;
    }

    private function is_ajax_call_get_public_admin_bar(){
        if (isset($_GET['cusmin-action'])) {
            if ($_GET['cusmin-action'] == 'cusmin-get-public-admin-bar') {
                return true;
            }
        }
        return false;
    }
}
