<?php

class AGCAExporter{
    public function __construct() {
        //add_action( 'admin_init', [$this, 'init'] );
       if ( ! function_exists( 'is_plugin_active' ) )
            require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
    }


    public function getSettings(){
        if(!$this->isAGCAActive()){
            return false;
        }
        return $this->exportAGCASettings();
    }

    function isAGCAActive(){
        return $this->isPluginActive('ag-custom-admin/plugin.php');
    }
    function isPluginActive($plugin){
        if(!is_admin()){
            return false;
        }
        return is_plugin_active($plugin);
    }
    function exportAGCASettings(){
        return $this->getOptions();
    }
    protected function getBoolOption($optionName){
        return get_option($optionName) == 'true' ? 1 : 0;
    }
    protected function getOnOffOption($optionName){
        return get_option($optionName) == 'on' ? 1 : 0;
    }
    protected function getTextOption($optionName){
        $option = get_option($optionName);
        return !empty($option) && 'false' != $option ? $option : '';
    }
    protected function getOptions(){
        $options = Array(
            //'agca_role_allbutadmin' => get_option('agca_role_allbutadmin'),
            //not applicable in cusmin:' agca_admin_bar_frontend' => get_option('agca_admin_bar_frontend'),
                '9' => $this->getBoolOption('agca_admin_bar_frontend_hide'),
                '39' => $this->getBoolOption('agca_login_register_remove'),
                '40' => $this->getTextOption('agca_login_register_href'),
                '41' => $this->getBoolOption('agca_login_lostpassword_remove'),
                'agca_admin_capability' => get_option('agca_admin_capability'),
                '1' => $this->getBoolOption('agca_screen_options_menu'),
                '2' =>$this->getBoolOption('agca_help_menu'),
                '23' => $this->getBoolOption('agca_logout_only'),
                '12' => $this->getTextOption('agca_custom_title'),
                '3' => $this->getBoolOption('agca_header'),
                '4' => $this->getBoolOption('agca_header_show_logout'),
                '24' => $this->getTextOption('agca_footer'),
            //old option, 'agca_privacy_options' => get_option('agca_privacy_options'),
                '13' => $this->getTextOption('agca_header_logo_custom'),
            //not applicable, use AB editor instead'agca_remove_site_link' => get_option('agca_remove_site_link'),
                '10' => $this->getTextOption('agca_wp_logo_custom'),
                '11' => $this->getTextOption('agca_wp_logo_custom_link'),
                '147' => $this->getBoolOption('agca_profile_color_scheme'),
            //'agca_site_heading' => get_option('agca_site_heading'),
            //not applicable,use AB editor'agca_custom_site_heading' => get_option('agca_custom_site_heading'),
                '19' => $this->getBoolOption('agca_update_bar'),
                '26' => $this->getTextOption('agca_footer_left'),
                '25' => $this->getBoolOption('agca_footer_left_hide'),
                '28' => $this->getTextOption('agca_footer_right'),
                '27' => $this->getBoolOption('agca_footer_right_hide'),
                '32' => $this->getBoolOption('agca_login_banner'),
                '33' => $this->getTextOption('agca_login_banner_text'),
                '36' => $this->getBoolOption('agca_login_photo_remove'),
                '34' => $this->getTextOption('agca_login_photo_url'),
                '35' => $this->getTextOption('agca_login_photo_href'),
                '37' => $this->getBoolOption('agca_login_round_box'),
                '38' => $this->getTextOption('agca_login_round_box_size'),
            //old option, not needed: 'agca_dashboard_icon' => get_option('agca_dashboard_icon'),
                '30' => $this->getTextOption('agca_dashboard_text'),
                '31' => $this->getTextOption('agca_dashboard_text_paragraph'),
                '29' => $this->getDashboardWidgetOptions(),
                '150' => $this->getBoolOption('agca_admin_bar_update_notifications'),
            //not needed 'agca_admin_bar_admin_themes' => get_option('agca_admin_bar_admin_themes'),
            //not applicable,use AB editor: 'agca_remove_top_bar_dropdowns' => get_option('agca_remove_top_bar_dropdowns'),
                '59' => $this->getOnOffOption('agca_admin_menu_turnonoff'),
                '60' => $this->getBoolOption('agca_admin_menu_agca_button_only'),
                '62' => $this->getBoolOption('agca_admin_menu_separators'),
                '63' => $this->getBoolOption('agca_admin_menu_icons'),
                '64' => $this->getBoolOption('agca_admin_menu_arrow'),
                '66' => $this->getBoolOption('agca_admin_menu_submenu_round'),
                '67' => $this->getTextOption('agca_admin_menu_submenu_round_size'),
                '68' => $this->getTextOption('agca_admin_menu_brand'),
                '69' => $this->getTextOption('agca_admin_menu_brand_link'),
                '61' => $this->getAMAutofoldingOption(),
                '65' => $this->getBoolOption('agca_admin_menu_collapse_button'),
                '70' => $this->getAdminBarOptions(),
                '71' => $this->getAdminMenuOptions(),
            //duplicate: probably remove: 'agca_colorizer_turnonof' => get_option('agca_colorizer_turnonof'),
                '7' => $this->getTextOption('agca_custom_js'),
                '6' => $this->getTextOption('agca_custom_css'),
                '42' => $this->getOnOffOption('agca_colorizer_turnonoff'),
            //not needed: 'agca_disablewarning' => get_option('agca_disablewarning'),
            //not applicable 'agca_disable_postver' => get_option('agca_disable_postver'),
                '89' => $this->getBoolOption('agca_menu_remove_client_profile'),
                '134' => $this->getRemoveCustomizeButtonOption(),
            //not needed: 'agca_selected_template' => get_option('agca_selected_template'),
            //not needed: 'agca_templates' => get_option('agca_templates'),
        );

        foreach ((array) $this->getColorizerOptions() as $key=>$val){
            $options[$key] = $val;
        }

        return $options;
    }

    private function getAdminBarOptions(){
            //not applicable, use AB editor 'agca_remove_your_profile' => get_option('agca_remove_your_profile'),
        //not applicable, use AB editor in Cusmin: 'agca_header_logo' => get_option('agca_header_logo'),

        $options = [
            'parent' => [],
            'child' => []
        ];

        if(get_option('agca_admin_bar_comments') == 'true'){
            $options['parent'][] = [
              'id' => 'comments',
              'hidden' => 1
            ];
        }

        if(get_option('agca_admin_bar_new_content') == 'true'){
            $options['parent'][] = [
                'id' => 'new-content',
                'hidden' => 1
            ];
        }

        if(get_option('agca_admin_bar_new_content_post') == 'true'){
            $options['child'][] = [
                'id' => 'new-post',
                'hidden' => 1
            ];
        }

        if(get_option('agca_admin_bar_new_content_page') == 'true'){
            $options['child'][] = [
                'id' => 'new-page',
                'hidden' => 1
            ];
        }
        if(get_option('agca_admin_bar_new_content_user') == 'true'){
            $options['child'][] = [
                'id' => 'new-user',
                'hidden' => 1
            ];
        }
        if(get_option('agca_admin_bar_new_content_media') == 'true'){
            $options['child'][] = [
                'id' => 'new-media',
                'hidden' => 1
            ];
        }
        if(get_option('agca_howdy')){
            $options['child'][] = [
                'id' => "my-account",
                'title' => get_option('agca_howdy')
            ];
        }
        //makes a problem
//        if(get_option('agca_logout')){
//            $options['child'][] = [
//                'id' => "logout",
//                'title' => get_option('agca_logout')
//            ];
//        }
        if(get_option('agca_remove_your_profile')){
            $options['child'][] = [
                'id' => "edit-profile",
                'hidden' => 1
            ];
        }
        return $options;
    }

    private function getAdminMenuOptions(){
//        'ag_edit_adminmenu_json' => get_option('ag_edit_adminmenu_json'),
//            'ag_edit_adminmenu_json_new' => get_option('ag_edit_adminmenu_json_new'),
//            //'ag_add_adminmenu_json' => get_option('ag_add_adminmenu_json'),
        $options = [
            'top' => [],
            'sub' => []
        ];

        $editItems = json_decode(get_option('ag_edit_adminmenu_json_new'));
        //print_r($editItems);die;
        foreach ((array) $editItems as $url=>$item){
            //print_r(['url'=>$url, 'item' => $item]);
            $o = [
                //'cap' => 'read',
                'title' => $item->new?$item->new:$item->name,
                'url' => $url
            ];
            if($item->remove){
                $o['hidden'] = 1;
            }
            $options['top'][] = $o;

            foreach ((array) $item->submenus as $index => $submenu){
                if(!isset($options['sub'][$url])){
                    $options['sub'][$url] = [];
                }
                $options['sub'][$url][$index] = [
                    'url' => $submenu->url,
                ];
                if($submenu->name){
                    $options['sub'][$url][$index]['title'] = $submenu->new?$submenu->new:$submenu->name;
                }
                if($submenu->remove){
                    $options['sub'][$url][$index]['hidden'] = 1;
                }
            }
        }
        //print_r($options);
        //die;

        //ADD NEW ITEMS
        $newItems = json_decode(get_option('ag_add_adminmenu_json'));
        foreach ((array) $newItems as $name => $item){
            //print_r(['key' => $name, 'item' => $item]);
            $options['top'][]= [
                'cap' => 'read',
                'custom'=>true,
                'icon'=>"dashicons-admin-generic",
                'title' => $name,
                'url' => $item->value,
                'target' => $item->target

            ];
        }
        return $options;
    }

    private function getAMAutofoldingOption(){
        $val = get_option('agca_admin_menu_autofold');
        switch ($val){
            case 'force': return '1';
            case 'disable': return '2';
        }
        return '0';
    }

    private function getRemoveCustomizeButtonOption(){
        if(get_option('agca_menu_remove_customize_button') == 'true'){
            return ['customize'];
        }else{
            return [];
        }
    }

    private function getColorizerOptions(){
        $colors = (array) json_decode(get_option('ag_colorizer_json'));
        //print_r($colOptions);
        $optionColors = [];
        if($colors){
            $optionColors = [
                '53' => $colors['color_admin_menu_behind_background'],
                '47' => $colors['color_admin_menu_font'],
                '50' => $colors['color_admin_menu_submenu_background'],
                '51' => $colors['color_admin_menu_submenu_background_hover'],
                '46' => $colors['color_admin_menu_top_button_background'],
                '48' => $colors['color_admin_menu_top_button_current_background'],
                '49' => $colors['color_admin_menu_top_button_hover_background'],
                '52' => $colors['color_admin_submenu_font'],
                '43' => $colors['color_background'],
                '54' => $colors['color_font_content'],
                '56' => $colors['color_font_footer'],
                '55' => $colors['color_font_header'],
                '45' => $colors['color_header'],
                '58' => $colors['color_widget_background'],
                '57' => $colors['color_widget_bar'],
                '44' => $colors['login_color_background']
            ];
        }

        return $optionColors;
    }

    private function getDashboardWidgetOptions(){
        $widgets = [
            'normal' => [],
            'side'  => []
        ];
        if(get_option('agca_dashboard_widget_welcome') == 'true'){
            $widgets['normal'][] = "welcome_panel";
        }
        if(get_option('agca_dashboard_widget_activity') == 'true'){
            $widgets['normal'][] = "dashboard_activity";
        }
//        if(get_option('agca_dashboard_widget_il') == 'true'){
//            $widgets['normal'][] = "";
//        }
//        if(get_option('agca_dashboard_widget_plugins') == 'true'){
//            $widgets['normal'][] = "";
//        }
        if(get_option('agca_dashboard_widget_qp') == 'true'){
            $widgets['side'][] = "dashboard_quick_press";
        }
        if(get_option('agca_dashboard_widget_rn') == 'true'){
            $widgets['normal'][] = "dashboard_right_now";
        }
//        if(get_option('agca_dashboard_widget_rd') == 'true'){
//            $widgets['normal'][] = "welcome_panel";
//        }
        if(get_option('agca_dashboard_widget_primary') == 'true'){
            $widgets['side'][] = "dashboard_primary";
        }
//        if(get_option('agca_dashboard_widget_secondary') == 'true'){
//            $widgets['normal'][] = "welcome_panel";
//        }

        return $widgets;
    }
}
