<?php
//TODO: Do some refactoring to make this code better, add class or so
function startsWith($haystack, $needle)
{
    $length = strlen($needle);
    return (substr($haystack, 0, $length) === $needle);
}

$blogusers = CusminOptions::getApplyToUsers();
global $wp_roles;
$users = array();
$groups = array();
$caps = $wp_roles->roles['administrator']['capabilities'];
foreach ($blogusers as $user) {
    $users[$user->ID] = array(
        'id' => $user->ID,
        'name' => $user->display_name . ' (' . $user->user_email . ')',
        'display_name' => $user->display_name,
        'email' => $user->user_email,
        'value' => $user->ID,
    );
}
foreach ($wp_roles->roles as $slug => $role) {
    $groups[$slug] = array(
        'name' => $role['name'],
        'value' => $slug
    );
}
$tmpCaps = array();
foreach ($caps as $key => $val) {
    if (startsWith($key, 'level_')) continue;
    $formattedValue = str_replace('_', ' ', $key);
    $tmpCaps[$key] = array(
        'name' => ucfirst($formattedValue),
        'value' => $key
    );
}
$caps = $tmpCaps;
?>
<script type="text/javascript">
    var cusmin = {
        wpv: '<?php echo get_bloginfo('version'); ?>',
        host: '<?php echo isset($_SERVER['HTTP_HOST'])?$_SERVER['HTTP_HOST']:(isset($_SERVER['SERVER_NAME'])?$_SERVER['SERVER_NAME']:''); ?>',
        blog: '<?php echo site_url(); ?>',
        users: <?php echo json_encode($users) ?>,
        groups: <?php echo json_encode($groups) ?>,
        capabilities: <?php echo json_encode($caps) ?>,
        editorReady: false,
        editorVersion: <?php echo CUSMIN_EDITOR_VERSION; ?>,
        selectedConfiguration: '<?php echo CusminOptions::getDefaultConfigurationSlug() ?>',
        selectedLoginConfiguration: '<?php echo CusminOptions::getSelectedPublicFacingConfigurationSlug() ?>',
        rules: <?php echo json_encode(CusminOptions::getAllRules()) ?>,
        configurations: <?php echo json_encode(CusminOptions::getAllConfigurationNames()) ?>,
        customizationsMatrix: <?php echo json_encode(CusminOptions::getCustomizationsMatrix()) ?>,
        hasMoreSlots: false,
        context: '<?php echo defined('CUSMIN_CONTEXT') ? CUSMIN_CONTEXT : ''; ?>',
        isMultisite: <?php echo is_multisite() ? 'true' : 'false' ?>,
        scripts: {
            codeHighlighter: '<?php echo plugins_url().'/cusmin/public/js/ace/ace.js'; ?>'
        },
        dashboardWidgets: null,
        customDashboardWidgets: <?php echo json_encode(CusminOptions::getCustomDashboardWidgets()) ?>,
        dashboardWidgetsOrderingUsername: <?php echo json_encode(CusminOptions::getDashboardWidgetsUsername()) ?>,
        pluginsList: <?php echo json_encode(get_plugins()); ?>,
        hiddenPluginsList: null,
        restrictedPages: null,
        custAppMode: <?php echo json_encode(CusminOptions::getCustomizationsApplicationMode()) ?>,
        trialEnded: <?php echo json_encode(CusminOptions::getTrialEnded()) ?>,
        isFirstTimeLoadWithAGCAEnabled: <?php echo CusminOptions::isFirstTimeLoadWithAGCAEnabled()?1:0; ?>,
        postMetaOptionsEnabled: <?php echo defined('CUSMIN_POST_META_OPTIONS') && CUSMIN_POST_META_OPTIONS ? 'true'  : 'false'; ?>,
        session:{
            codeEditors:{}
        },
        config: {
            version: '<?php echo CUSMIN_PLUGIN_VERSION; ?>',
            endPoint: '<?php echo CUSMIN_ENDPOINT; ?>',
            adminUrl: '<?php echo admin_url(''); ?>',
            apiVersion: '<?php echo CUSMIN_API_VERSION; ?>',
            context: '<?php echo CUSMIN_CONTEXT; ?>',
            debug: <?php echo CusminConfiguration::Debug()?'true':'false'; ?>,
            debugLevel: <?php echo CusminConfiguration::DebugLevel(); ?>,
            basePath: '<?php echo plugins_url().'/cusmin/'; ?>',
            updateNonce: '<?php echo wp_create_nonce('puc_check_for_updates'); ?>',
            scriptType: '<?php echo CUSMIN_SCRIPT_TYPE; ?>',
            transitions: <?php echo CUSMIN_TRANSITIONS ? 'true' : 'false'; ?>,
        },
        original: {
            //not changing in current session what ever user does
            menu: {
                top: <?php echo json_encode(CusminOptions::getOriginalMenuTop());  ?>,
                sub: <?php echo json_encode(CusminOptions::getOriginalMenuSub());  ?>
            }, //original menu
            cmenu: {
                top: <?php echo json_encode(CusminOptions::getCustomMenuTop(), JSON_FORCE_OBJECT);  ?>,
                sub: <?php echo json_encode(CusminOptions::getCustomMenuSub(), JSON_FORCE_OBJECT);  ?>
            },
            adminBar: {
                parent:  <?php echo json_encode(CusminOptions::$ab->getOriginalParents());  ?>,
                child:  <?php echo json_encode(CusminOptions::$ab->getOriginalChildren());  ?>
            },
            cadminBar: {
                parent:  <?php echo json_encode(CusminOptions::getCustomizedAdminBarParentNodes());  ?>,
                child:  <?php echo json_encode(CusminOptions::getCustomizedAdminBarChildNodes());  ?>
            }
        },
        menu: {
            top: <?php echo json_encode(CusminOptions::getMenuTop());  ?>,
            sub: <?php echo json_encode(CusminOptions::getMenuSub());  ?>
        }, //menu with customizations
        cmenu: {
            top: <?php echo json_encode(CusminOptions::getCustomMenuTop(), JSON_FORCE_OBJECT);  ?>,
            sub: <?php echo json_encode(CusminOptions::getCustomMenuSub(), JSON_FORCE_OBJECT);  ?>
        }, //current session customizations
        adminBar: {
            parent:  <?php echo json_encode(CusminOptions::$ab->getOriginalParents());  ?>,
            child:  <?php echo json_encode(CusminOptions::$ab->getOriginalChildren());  ?>
        },
        cadminBar: {
            parent:  <?php echo json_encode(CusminOptions::getCustomizedAdminBarParentNodes());  ?>,
            child:  <?php echo json_encode(CusminOptions::getCustomizedAdminBarChildNodes());  ?>
        },
        content:{
            columns: null,
            //TODO: Add support for adding custom content type and loading their metaboxes
            metaboxes: null,
            postTypes: <?php echo json_encode(array_values(get_post_types())); ?>
        },
      /*  content: {
            columns: {
                posts: <?php echo json_encode(CusminOptions::getColumnsApplier()->postsColumns());  ?>
            },
            bulkActions: {
                posts: <?php echo json_encode(CusminOptions::getColumnsApplier()->bulkActionsPosts());  ?>
            }
        },*/
        vendors: <?php echo json_encode(CusminOptions::getEnabledPluginsList());  ?>,
        settings: {}, //used for saving temporary settings globally
        logs:{
            data:[],
            show:function(){
                for(var i in this.data){
                    console.log(this.data[i]);
                }
            }
        }
    }
</script>
<div id="cusmin-wrap">
    <?php wp_nonce_field('cusmin', 'cusmin_nonce'); ?>
    <div class="fb-like" style="position: absolute;margin-top: -43px;margin-left: 254px;" data-href="<?php echo CUSMIN_ENDPOINT; ?>"
         data-layout="button" data-action="like" data-show-faces="true" data-share="true"></div>
    <div id="cusmin-app" class="checking-status"></div>
    <div id="cusmin-status">
        <div class="wrap">
            <div class="message"></div>
        </div>
    </div>
    <div id="cusmin-flash-text">
        <div class="wrap">
            <div class="message"></div>
        </div>
    </div>
    <div id="cusmin-modal" class="">
        <div class="wrap">
            <div class="inner">
                <div class="title">Message</div>
                <div class="message">Welcome to Cusmin!</div>
                <div class="actions clearfix">
                    <button class="ok">OK</button>
                    <button class="cancel">Cancel</button>
                    <button class="close">Close</button>
                </div>
            </div>
        </div>
    </div>
    <div id="cusmin-textarea-modal">
        <span title="Close" class="close dashicons dashicons-no"></span>
        <div class="wrap">
            <?php wp_editor("", "cusmin", $settings = array(
                'editor_height' => 300
            )); ?>
            <div class="actions">
                <button class="cusmin-save clearfix">Save</button>
                <button class="cusmin-cancel clearfix">Cancel</button>
            </div>
        </div>
    </div>
    <div id="fb-root"></div>
    <script>(function (d, s, id) {
            var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) return;
            js = d.createElement(s);
            js.id = id;
            js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.5&appId=1081363631879895";
            fjs.parentNode.insertBefore(js, fjs);
        }(document, 'script', 'facebook-jssdk'));</script>
    <style type="text/css" id="colorizer-temp-css"></style>
    <style type="text/css" id="admin-menu-temp-css"></style>
    <style type="text/css" id="admin-bar-temp-css"></style>
    <textarea id="cusmin-ta-test-mce-init" style="display: none"></textarea>
</div>
<script>
    jQuery(function(){
        wp.editor.initialize('cusmin-ta-test-mce-init');
        jQuery( document ).on( 'tinymce-editor-init', function( event, editor ) {
            cusmin.editorReady = true;
        });
    })
</script>