<?php

/**
 *
 * @link              https://cusmin.com
 * @since             0.1
 * @package           Cusmin
 *
 * @wordpress-plugin
 * Plugin Name:       Cusmin
 * Plugin URI:        https://cusmin.com
 * Description:       The Ultimate WordPress Dashboard Customization Plugin
 * Version:           1.52
 * Author:            Cusmin
 * Author URI:        https://cusmin.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       cusmin
 * Domain Path:       /languages
 */

require_once plugin_dir_path( __FILE__ ) . 'configuration.php';

require_once 'plugin-update-checker/plugin-update-checker.php';
$cusminUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
	CUSMIN_ENDPOINT.'repo/'.(CUSMIN_DEV?'dev':'prod').'.json',
	__FILE__,
	'cusmin'
);


// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-cusmin-activator.php
 */
function activate_cusmin() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-cusmin-activator.php';
	Cusmin_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-cusmin-deactivator.php
 */
function deactivate_cusmin() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-cusmin-deactivator.php';
	Cusmin_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_cusmin' );
register_deactivation_hook( __FILE__, 'deactivate_cusmin' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-cusmin.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_cusmin($cuc) {

	$plugin = new Cusmin($cuc);
	$plugin->run();

}
run_cusmin($cusminUpdateChecker);