<?php

include_once( ABSPATH . 'wp-admin/includes/class-wp-upgrader.php' );

class Cusmin_Quiet_Upgrader_Skin extends \WP_Upgrader_Skin {
    public function feedback($string, ...$args )
    {
        // just keep it quiet
    }
}

class CusminPluginActivator {

    public function __construct()
    {
        include_once( ABSPATH . 'wp-admin/includes/plugin-install.php' ); //for plugins_api..
        //includes necessary for Plugin_Upgrader and Plugin_Installer_Skin
        include_once( ABSPATH . 'wp-admin/includes/file.php' );
        include_once( ABSPATH . 'wp-admin/includes/misc.php' );

    }

    public function install($plugin){


        $api = plugins_api( 'plugin_information', array(
            'slug' => $plugin,
            'fields' => array(
                'short_description' => false,
                'sections' => false,
                'requires' => false,
                'rating' => false,
                'ratings' => false,
                'downloaded' => false,
                'last_updated' => false,
                'added' => false,
                'tags' => false,
                'compatibility' => false,
                'homepage' => false,
                'donate_link' => false,
            ),
        ));


        $upgrader = new Plugin_Upgrader( new Cusmin_Quiet_Upgrader_Skin( compact('title', 'url', 'nonce', 'plugin', 'api') ) );
        return $upgrader->install($api->download_link);
    }

    public function activate(){
        return activate_plugin('wps-hide-login/wps-hide-login.php');
    }

    public function isPluginActivated($plugin) {
        return is_plugin_active($plugin);
    }

    public function isPluginInstalled($plugin){
        return in_array( $plugin, apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) );
    }

}
