<?php

//Used for loading and caching scripts and styles
//require '../../../../../wp-load.php';
if (file_exists('../../../../wp-load.php')) {
    // Make WordPress functions and methods available
    require '../../../../wp-load.php';

// If using alternative WordPress file structure like Roots' Bedrock
} else {
    // WP's constant ABSPATH is not available, so use $_SERVER['DOCUMENT_ROOT'] to get the web root
    $directory = new RecursiveDirectoryIterator($_SERVER['DOCUMENT_ROOT']);

    // Recursively search web root for wp-load.php
    foreach (new RecursiveIteratorIterator($directory) as $file) {
        // wp-load.php found, require and break loop
        if ($file->getFilename() === 'wp-load.php') {
            // Make WordPress functions and methods available
            require $file->getPathname();
            break;
        }
    }
}

header("Cache-Control: max-age=2592000"); //30 days cache
header("Pragma: cache");

try {
    if(!class_exists('CusminOptions')) {
        echo '/*CusminOptions does not exist:'. plugin_dir_path(dirname(__FILE__)) . 'admin/includes/class-cusmin-options.php'.' */';
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/includes/class-cusmin-options.php';
    }

    if(!class_exists('CusminAdmin')) {
        echo '/*CusminAdmin does not exist:'. plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-cusmin-admin.php'.' */';
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-cusmin-admin.php';
    }

    if(CusminOptions::getTrialEnded()) return false;

    $script = '';
    $type = 'css';
    $context = 'site';
    $additionalJS = '';

    if (isset($_GET["type"])) {
        $type = $_GET["type"];
    }
    if (isset($_GET["ctx"])) {
        $context = $_GET["ctx"];
    }

    if ($type == "css") {
        header('Content-type: text/css');
        if ($context == 'admin') {
            if (is_user_logged_in()) {
                $script = CusminOptions::getAdminCSSCustomizations();
            }
        } else if ($context == 'login') {
            $script = CusminOptions::getLoginCSSCustomizations();
        } else {
            $script = CusminOptions::getSiteCustomCSSCustomizations();
            if (is_user_logged_in()) {//logged in user seeing public pages
                $script .= CusminOptions::getAdminCSSCustomizations();
            }
        }
        $script.=CusminOptions::getCommonCss();
    } else if ($type == "js") {
        header('Content-type: application/javascript');
        if ($context == 'admin') {
            if (is_user_logged_in()) {
                $script = CusminOptions::getAdminJSCustomizations();
                $additionalJS = CusminOptions::getAdminAdditionalScripts();
            }
        } else if ($context == 'login') {
            $script = CusminOptions::getLoginJSCustomizations();
        } else {
            $script = CusminOptions::getSiteCustomJSCustomizations();
            if (is_user_logged_in()) { //logged in user seeing public pages
                $script .= CusminOptions::getAdminJSCustomizations();
                $additionalJS = CusminOptions::getAdminAdditionalScripts();
            }
        }
        $script = CusminAdmin::wrapJS($script.$additionalJS);
    }
    //TODO: Leverage PHP file caching
    echo $script;
} catch (\Exception $e) {
    echo '/*'.$e->getCode().':'.$e->getMessage().':'.$e->getFile().':'.$e->getLine().'*/';
}