<?php

class CusminAjax{

    protected $action;
    protected $data;

    const AGCA_PLUGIN_FILE ='ag-custom-admin/plugin.php';
    const WHL_PLUGIN_FILE = 'wps-hide-login/wps-hide-login.php';

    protected function whl_plugin_update_options($data){
        $slug = $data['slug'];
        $errorSlug = $data['errorSlug'];

        if(!empty($slug) && !$this->verifySlugFormat($slug)) {
            $this->error('Login slug cannot have special characters!');
        }

        if(!empty($errorSlug) && !$this->verifySlugFormat($errorSlug)) {
            $this->error('Login redirect slug cannot have special characters!');
        }
        update_option('whl_page', $slug);
        update_option('whl_redirect_admin', $errorSlug);

        echo 1;
    }

    protected function whl_plugin_get_options(){
        if(!is_plugin_active(self::WHL_PLUGIN_FILE)) {
            echo 0;die;
        }
        wp_send_json([
            'error' => false,
            'slug' => get_option('whl_page'),
            'redirect_page' => get_option('whl_redirect_admin')
        ]);
    }

    protected function whl_plugin_install($data){

        $error = false;
        if(!is_plugin_active(self::WHL_PLUGIN_FILE)) {

            require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-cusmin-plugin-activator.php';

            ob_start();
            $pluginSlug = 'wps-hide-login';
            $pluginFile = self::WHL_PLUGIN_FILE;
            $pluginActivator = new CusminPluginActivator();

            if(!$pluginActivator->isPluginInstalled($pluginFile)) {
                $pluginActivator->install($pluginSlug);
            }

            $result = $pluginActivator->activate($pluginFile);
            ob_end_clean();

            if(is_wp_error($result)){
                $error = $result->get_error_message();
            }
        }

        wp_send_json([
            'error' => $error,
            'slug' => get_option('whl_page'),
            'redirect_page' => get_option('whl_redirect_admin')
        ]);
    }

    public function ajax(){
        $this->securityChecks();
        $this->prepareData($_POST);

        $this->{$this->action}($this->data);

        //echo json_encode($_POST);
        wp_die();
        die;
    }

    protected function prepareData($post) {
        if(empty($post)) {
            $this->error('Empty request (cusmin-ajax).');
        }

        $cusminAction = $post['cusmin_action'];
        if(!$this->verifySlugFormat($cusminAction)) {
            $this->error('Invalid Cusmin action characters (cusmin-ajax)');
        }

        $this->action = $cusminAction;
        $this->data = $post['data'];
    }

    protected function securityChecks(){
        if(!$this->isCurrentUserAdmin()){
            $this->error('You are not an administrator.');
        }
        //use only from admin dahsboard
        if (!is_admin()) {
            exit;
        }
    }

    protected function isCurrentUserAdmin()
    {
        include_once(ABSPATH . 'wp-includes/pluggable.php');
        if (!is_multisite()) {
            return current_user_can('manage_options');
        } else {
            //TODO: Admin check is disabled for admin on multisite!!!
            //TODO: Make it work on multisite
            /*if(!is_super_admin()){
                echo 'Current user is not super admin';
                exit;
            }*/
            return true;
        }
    }

    protected function verifySlugFormat($string){
        return preg_match('/^[\w-]+$/', $string);

    }

    protected function error($error){
        echo $error;
        exit;
    }

    public function is_agca_active()
    {
        return is_plugin_active(self::AGCA_PLUGIN_FILE);
    }
}