<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://example.com
 * @since      1.0.0
 *
 * @package    Cusmin
 * @subpackage Cusmin/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Cusmin
 * @subpackage Cusmin/admin
 * @author     Your Name <email@example.com>
 */
class CusminAdmin
{
    //TODO: Make this class as dispatcher, all implementations should be in separate classes
    const CUSMIN_PAGE_NAME = 'settings_page_cusmin';
    const CUSMIN_SCRIPT_PERMALINK_BASE = 'cusmin-script';

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $plugin_name The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $version The current version of this plugin.
     */
    private $version;

    private $debug = true;

    private $options;

    /**
     * @var CusminApplier
     */
    private static $applier;

    private $css;

    private $js;

    private $loginCSS;

    private $loginJS;

    //try to use this as static
    private $php;

    private $customCSS;

    /**
     * Initializes class and sets its properties
     * @param $plugin_name
     * @param $version
     */
    public function __construct($plugin_name, $version)
    {
        if (isset($_GET['debug'])) {
            $value = $_GET['debug'];
            if ($value == '1' || $value == '2' || $value == '3') {
                CusminConfiguration::DebugLevel($value);
            }
            if ($value == 'false') {
                CusminConfiguration::Debug(false);
                $this->debug = false;
            } else {
                CusminConfiguration::Debug(true);
                $this->debug = true;
            }
        }

        $this->css = '';
        $this->js = '';
        $this->loginCSS = '';
        $this->loginJS = '';
        $this->php = array();
        $this->customCSS = '';
        $this->plugin_name = $plugin_name;
        $this->version = $version;
        $this->load_dependencies();
        $this->checkActions();
        $this->checkPOST();
        $this->checkAGCAMigration();
        $this->options = new CusminOptions();
    }

    public function getOptions()
    {
        return $this->options;
    }

    public function cusmin_cpt() {

        add_thickbox();
        wp_enqueue_script( 'thickbox' );

        wp_enqueue_style( 'thickbox' );
        // Set UI labels for Custom Post Type
        $labels = array(
            'name'                => _x( 'Cusmin Pages', 'Post Type General Name', 'cusmin' ),
            'singular_name'       => _x( 'Cusmin Page', 'Post Type Singular Name', 'cusmin' ),
            'menu_name'           => __( 'Cusmin Pages', 'cusmin' ),
            'parent_item_colon'   => __( 'Parent Cusmin Page', 'cusmin' ),
            'all_items'           => __( 'All Cusmin Pages', 'cusmin' ),
            'view_item'           => __( 'View Cusmin Page', 'cusmin' ),
            'add_new_item'        => __( 'Add New Cusmin Page', 'cusmin' ),
            'add_new'             => __( 'Add New', 'cusmin' ),
            'edit_item'           => __( 'Edit Cusmin Page', 'cusmin' ),
            'update_item'         => __( 'Update Cusmin page', 'cusmin' ),
            'search_items'        => __( 'Search Cusmin Page', 'cusmin' ),
            'not_found'           => __( 'Not Found', 'cusmin' ),
            'not_found_in_trash'  => __( 'Not found in Trash', 'cusmin' ),
        );

        // Set other options for Custom Post Type
        $args = array(
            'label'               => __( 'cusminpage', 'cusmin' ),
            'description'         => __( 'Cusmin pages', 'cusmin' ),
            'labels'              => $labels,
            // Features this CPT supports in Post Editor
            //'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
            'supports'            => array('title', 'editor'),
            // You can associate this CPT with a taxonomy or custom taxonomy.
            //'taxonomies'          => array( 'genres' ),
            'taxonomies'          => array(  ),
            /* A hierarchical CPT is like Pages and can have
            * Parent and child items. A non-hierarchical CPT
            * is like Posts.
            */
            'hierarchical'        => false,
            'public'              => false,
            'show_ui'             => true,
            'show_in_menu'        => false,
            'show_in_nav_menus'   => false,
            'show_in_admin_bar'   => false,
            'menu_position'       => 5,
            'can_export'          => true,
            'has_archive'         => false,
            'exclude_from_search' => true,
            'publicly_queryable'  => false,
            'capability_type'     => 'post',
            'show_in_rest' => true,

        );

        //print_r(get_post_type_object('post'));die;

        // Registering your Custom Post Type
        register_post_type( 'cusminpages', $args );

//        //Elementor support
//        $cpt_support = get_option( 'elementor_cpt_support' );
//        if( ! in_array( 'cusminpages', $cpt_support ) ) {
//            $cpt_support[] = 'cusminpages'; //append to array
//            update_option( 'elementor_cpt_support', $cpt_support ); //update database
//        }

    }

    public function checkActions()
    {
        if (isset($_GET['cusmin-action'])) {
            $action = $_GET['cusmin-action'];

            if($action == 'cusmin-get-public-admin-bar'){
                $this->securityGETPublicChecks();
            }else{
                $this->securityGETAdminChecks();
            }

            if ($action == 'dismiss-notice') {
                $noticeId = isset($_GET['notice'])?$_GET['notice']:'';
                CusminOptions::noticesDismiss($noticeId);
                die;
            }

            $this->securityAdminChecks();
            if ($action == 'options') {
                $options = CusminOptions::get();
                print_r($options);
                die;
            } else if ($action == 'options-json') {
                $options = CusminOptions::get();
                echo json_encode($options);
                die;
            }
            if ($action == 'reset-cusmin') {
                delete_option(CusminOptions::OPTION_NAME);
                echo 'Cusmin settings reset to defaults';
                die;
            } else if ($action == 'delete-config') {
                if (isset($_GET['config'])) {
                    $config = $_GET['config'];
                    CusminOptions::removeConfiguration($config);
                    echo 'Removed applied configuration.';
                    die;
                }
            } else if ($action == 'reset-config') {
                if (isset($_GET['config'])) {
                    $config = $_GET['config'];
                    CusminOptions::clearCustomization($config);
                    echo 'Reset applied configuration.';
                    die;
                }
            } else if($action == 'revert-version'){
                set_transient('cusmin-revert-version', $this->version);
                die;
            } else if($action == 'get-screen-id'){
                add_action( 'current_screen', array($this, 'admin_action_get_current_screen' ));
            } else if($action == 'search-repo-plugins'){
                include_once(ABSPATH . 'wp-admin/includes/plugin-install.php');
                $api = plugins_api( 'query_plugins', array(
                    'page' => 1,
                    'per_page' => 30,
                    'fields' => array(
                                'last_updated' => 1,
                                'icons' => 1,
                                'active_installs' => 1
                    ),
                    'locale' => 'en_US',
                    'installed_plugins' => array(),
                    'search' => isset($_REQUEST['st'])?$_REQUEST['st']:''
                ));
                $plugins = [];
                foreach((array) $api->plugins as $p){
                    if(is_array($p)){
                        $plugins[$p['slug']] = html_entity_decode($p['name']);
                    }else{
                        $plugins[$p->slug] = html_entity_decode($p->name);
                    }
                }
                //print_r($plugins);die;
                echo json_encode($plugins);
                die;
            } else if($action == 'clear-post-meta-options'){
                $results = CusminOptions::clearPostMetaAppliedCustomizations();
                echo $results;
                die;
            }
            //TODO: Add revert to previous state or undo action
        }
    }

//    /**
//     * This function runs when WordPress completes its upgrade process
//     * It iterates through each plugin updated to see if ours is included
//     * @param $upgrader_object Array
//     * @param $options Array
//     */
//    public function plugin_upgrade_completed( $upgrader_object, $options ) {
//        // The path to our plugin's main file
//        $our_plugin = 'cusmin/cusmin.php';
//        // If an update has taken place and the updated type is plugins and the plugins element exists
//        if( $options['action'] == 'update' && $options['type'] == 'plugin' && isset( $options['plugins'] ) ) {
//            // Iterate through the plugins being updated and check if ours is there
//            foreach( $options['plugins'] as $plugin ) {
//                if( $plugin == $our_plugin ) {
//                    flush_rewrite_rules();
//                }
//            }
//        }
//    }

    public function cusmin_scripts($vars = '' ){
        $hook = current_filter();

        //$structure = get_option( 'permalink_structure' );
        //print_r($structure);die;

        // load 'style.php' from the current theme.
        'template_redirect' === $hook
        && get_query_var( self::CUSMIN_SCRIPT_PERMALINK_BASE )
        && load_template(plugin_dir_path(__DIR__) . 'public/script.php', TRUE, TRUE )
        && exit;

        // Add a rewrite rule.
        'init' === $hook && add_rewrite_endpoint( self::CUSMIN_SCRIPT_PERMALINK_BASE, EP_ROOT );

        // Make sure the variable is not empty.
//        'request' === $hook
//        && isset ( $vars[self::CUSMIN_SCRIPT_PERMALINK_BASE] )
//        && empty ( $vars[self::CUSMIN_SCRIPT_PERMALINK_BASE] )
//        && $vars[self::CUSMIN_SCRIPT_PERMALINK_BASE] = '/*dddfff fff*/';

        return $vars;
    }

    public function admin_post_cusmin_api(){
        if (!((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == 443)) {
            //echo "HTTPS is required for this connection."; die;
        }

        if(empty($_POST)) {
            echo 0; die(0);
        }

        if(!defined('CUSMIN_API_SECRET') || CUSMIN_API_SECRET === '') {
            echo "Cusmin secret key is not set"; die;
        }

        require_once plugin_dir_path(dirname(__FILE__)) . 'packages/firebase/php-jwt/src/class-before-valid-exception.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'packages/firebase/php-jwt/src/class-expired-exception.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'packages/firebase/php-jwt/src/class-signature-invalid-exception.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'packages/firebase/php-jwt/src/class-jwk.php';
        require_once plugin_dir_path(dirname(__FILE__)) . 'packages/firebase/php-jwt/src/class-jwt.php';

        $cusminAction = $_POST['cusmin_action'];
        $token        = $_POST['token'];

        $decoded = JWT::decode($token, CUSMIN_API_SECRET, array('HS256'));

        print_r($decoded);

        switch ($cusminAction){

        }
        //print_r(get_option('cusmin'));die;
        die;
    }

    public function admin_action_get_current_screen(){
        $screen = get_current_screen();
        if($screen){
            echo $screen->id;
        }
        die;
    }

    public function checkPOST()
    {
        if (isset($_POST['cusmin'])) {
            $this->securityPOSTChecks();
            $ph = new Cusmin_Post_Handler($_POST['cusmin'], $this->isCurrentUserAdmin());
            echo $ph->handle();
            die;
        }
    }

    protected function securityPOSTChecks()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            exit;
        }
        if (CUSMIN_REQUEST_VERIFICATION) {
            return true;
        }
        if (!is_admin()) {
            exit;
        }
        include_once(ABSPATH . 'wp-includes/pluggable.php');
        if (!is_multisite()) {
            if (!is_user_logged_in()) {
                echo 'User is not logged in.';
                exit;
            }
            //TODO: Maybe check for nonce format?
            if (!wp_verify_nonce($_POST['cusmin']['cusmin_nonce'], 'cusmin')) {
                echo 'Nonce verification failed.';
                exit;
            }
        } else {
            //TODO: Make it work on multisite
            /*if(!is_super_admin()){
                echo 'Current user is not super admin';
                exit;
            }*/
        }
    }

    protected function securityGETAdminChecks(){
        $this->securityGETChecks(true);
    }
    protected function securityGETPublicChecks(){
        $this->securityGETChecks(false);
    }

    protected function securityGETChecks($isAdminContext = true)
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
            exit;
        }
        if (!CUSMIN_REQUEST_VERIFICATION) {
            return true;
        }
        if($isAdminContext){
            if (!is_admin()) {
                exit;
            }
        }else{
            if (is_admin()) {
                exit;
            }
        }

        include_once(ABSPATH . 'wp-includes/pluggable.php');
        if (!is_multisite()) {
            if (!is_user_logged_in()) {
                echo 'User is not logged in.';
                exit;
            }
        } else {
            //TODO: Make it work on multisite
            /*if(!is_super_admin()){
                echo 'Current user is not super admin';
                exit;
            }*/
        }
    }

    protected function isCurrentUserAdmin(){
        include_once(ABSPATH . 'wp-includes/pluggable.php');
        if (!is_multisite()) {
            return current_user_can('manage_options');
        }else{
            //TODO: Admin check is disabled for admin on multisite!!!
            //TODO: Make it work on multisite
            /*if(!is_super_admin()){
                echo 'Current user is not super admin';
                exit;
            }*/
            return true;
        }
    }

    protected function securityAdminChecks()
    {
        if(!$this->isCurrentUserAdmin()){
            echo 'You are not administrator.';
            exit;
        }
    }

    private function checkAGCAMigration()
    {
        //TODO: Check if AGCA is active and try to migrate enabled settings to Cusmin. Move this check where appropriate.
        //TODO: AGCA Migration: make sure to have a flag to migrate settings only once. Create external class for migration
    }

    public function load_dependencies()
    {
        /**
         * Page used to generate options page.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/includes/class-options-page.php';

        /**
         * Views manager
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/includes/class-views.php';

        /**
         * Collection of Cusmin POST actions
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/includes/class-post-action.php';

        /**
         * Handles Cusmin POST requests
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/includes/class-post-handler.php';

        /**
         * Class for options management
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/includes/class-cusmin-options.php';
    }

    public function login_redirect($redirect_to, $request, $user){

        if($user instanceof WP_User){
            $customization = CusminOptions::getUserCustomizations($user);
            if(!empty($customization['php'][157])){
                return $customization['php'][157];
            }
        }

        return $redirect_to;
    }

    public function is_agca_active()
    {
        is_plugin_active('ag-custom-admin/plugin.php');
    }

    /**
     * Register the stylesheets for the admin area.
     *
     * @since    1.0.0
     */
    public function enqueue_styles()
    {

        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Cusmin_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Cusmin_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
        $this->enqueue_style('admin-panel', 'bundle/css/cusmin.admin.panel.min.css');

        //TODO: Don't use FA in admin panel if no settings are set to use it
        $this->enqueue_style('fa', '../public/css/fa/css/font-awesome.min.css');

        $this->enqueue_style('material-icons', '../public/css/mi/css/material.min.css');
        //$this->enqueue_style('cusmin-flipclock', '../public/plugins/flipclock/flipclock.min.css');

        if ($this->isCusminSettingsPage()) {

            $this->enqueue_style('admin', 'bundle/css/cusmin.admin.min.css');
            wp_enqueue_media();
            wp_enqueue_editor();
            wp_enqueue_style('wp-color-picker');
        }
    }

    /**
     * WP API facing method
     * @param $slug
     * @param $location
     * @param array $dependencies
     */
    private function enqueue_style($slug, $location, $dependencies = array())
    {
        wp_enqueue_style($this->plugin_name . '-'. $slug, plugin_dir_url(__FILE__) . $location, $dependencies, $this->version, 'all');
    }
    /**
     * Register the JavaScript for the admin area.
     *
     * @since    1.0.0
     */
    public function enqueue_scripts($hook)
    {
        //$suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';
        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Cusmin_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Cusmin_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */

        //assets.pinterest.com/js/pinit.js
        $this->enqueue('jquery');

        //If Dashboard page and pinterest widget enabled, include pinterest script
        if($hook == 'index.php'){
            try {
                if(isset($this->php[72])) {
                    foreach ((array) $this->php[72] as $widget) {
                        if($widget['template'] === 'pinterest') {
                            wp_enqueue_script( 'pinterest', 'https://assets.pinterest.com/js/pinit.js', array(), false, true);
                            break;
                        }
                    }
                }
            }catch (\Exception $e) {}
        }

        if ($hook != self::CUSMIN_PAGE_NAME) {
            return false;
        }

        //We are on Cusmin settings page
        $cusminJSBundleScript = 'bundle/js/cusmin.min.js';
        if(!empty($_GET['debug']) && $_GET['debug'] == 'true'){
            $cusminJSBundleScript = 'bundle/js/cusmin.js';
        }
        $this->register_script('cusmin', $cusminJSBundleScript, array('jquery', 'wp-color-picker'));
        //$this->register_script('cusmin-flipclock', '../public/plugins/flipclock/flipclock.min.js', array('jquery'));


        $this->enqueue('jquery');
        $this->enqueue('jquery-ui-tooltip');
        $this->enqueue('jquery-ui-sortable');
        $this->enqueue('cusmin');
        //$this->enqueue('cusmin-flipclock');
    }

    /**
     * Used as API level script enquer
     * @param $slug script short name, keyword
     * @param $location location on disk
     * @param array $dependencies - array if dependent of other scripts
     */
    public function enqueue_script($slug, $location, $dependencies = array())
    {
        $name = ($slug === '' || $slug[0] === '-') ? $this->plugin_name . $slug : $slug;
        wp_enqueue_script($name, plugin_dir_url(__FILE__) . $location, $dependencies, $this->version, true);
    }

    public function enqueue($slug)
    {
        wp_enqueue_script($slug);
    }

    public function enqueue_login_scripts()
    {
        $this->enqueue('jquery');
    }

    public function register_script($slug, $location, $dependencies = array())
    {
        $name = ($slug === '' || $slug[0] === '-') ? $this->plugin_name . $slug : $slug;
        wp_register_script($name, plugin_dir_url(__FILE__) . $location, $dependencies, $this->version, true);
    }

    //TODO: Register script hosted on Cusmin service
    public function register_remote_script($slug, $location, $dependencies = array())
    {
        //$name = ($slug === '' || $slug[0] === '-') ? $this->plugin_name . $slug : $slug;
        // wp_register_script($name, plugin_dir_url(__FILE__) . $location, $dependencies, $this->version, true);
    }

    /**
     * Adds a link to the plugin settings page
     *
     * @since        1.0.0
     * @param        array $links The current array of links
     * @return        array                    The modified array of links
     */
    	public function settings_link( $links ) {

            $help_link = '<a target="_blank" href="https://cusmin.com/docs?ref=plugins-page" >' . __( 'Help' ) . '</a>';
            array_unshift( $links, $help_link );

            $settings_link = sprintf( '<a href="%s">%s</a>', admin_url( 'options-general.php?page=' . $this->plugin_name ), __( 'Settings', 'cusmin' ) );
            array_unshift( $links, $settings_link );

            return $links;

        } // settings_link()

    public function cusmin_custom_admin_page($a){
        $pageSlug = $_GET['page'];
        $options = self::$applier->setting_158();
        $prefix = 'cusmin_';
        if (substr($pageSlug, 0, strlen($prefix)) == $prefix) {
            $pageSlug = substr($pageSlug, strlen($prefix));
        }

        $page = $options[$pageSlug];

        ?>
            <div class="wrap">
                <h1><?php echo $page['title']; ?></h1>
                <?php echo do_shortcode($page['content']); ?>
            </div>
        <?php
    }

    public function add_custom_admin_pages(){
        $c = NULL;
        if(isset($_GET['page']) && $_GET['page'] == 'cusmin'){
            $c = CusminOptions::getDefaultConfiguration();
        }else{
            $c = CusminOptions::getCurrentUserCustomizations();
        }

        if(!empty($c['php'])){
            $a = new CusminApplier($c['php']);
            if ($a->setting_158()) {
                $options = $a->setting_158();
                foreach((array) $options as $option){
                    add_menu_page( $option['title'], $option['title'], 'read', 'cusmin_'.$option['slug'],  array($this, 'cusmin_custom_admin_page'), 'dashicons-format-aside', 9999 );
                }
            }
        }
    }

    /**
     * Adds a settings page link to a menu
     *
     * @since        1.0.0
     * @return        void
     */
    public function add_menu()
    {
        add_options_page(
            apply_filters($this->plugin_name . '-settings-page-title', __('Cusmin Settings', 'cusmin')),
            apply_filters($this->plugin_name . '-settings-menu-title', __('Cusmin', 'cusmin')),
            'manage_options',
            $this->plugin_name,
            array($this, 'options_page')
        );

    } // add_menu()

    public function add_custom_pages(){
        /*add_menu_page(
            'Include Text',     // page title
            'Include Text',     // menu title
            'read',   // capability
            'include-text',     // menu slug
            array($this, 'render_custom_page')
        );
        add_menu_page(
            'adgd Taext',     // page title
            'sad Text',     // menu title
            'read',   // capability
            'include-text3',     // menu slug
            array($this, 'render_custom_page')
        );*/
    }

    function inspect_scripts() {
        //run only on Cusmin Settings page
        $requestUrl = isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI']: null;
        if (strpos($requestUrl, '/options-general.php?page=cusmin')) {
            wp_deregister_script('react');
            wp_deregister_script('react-dom');
        }
    }

    public function render_custom_page(){
        global $title;

        print '<div class="wrap">';
        print "<h1>$title</h1>";

        print "<p class='description'>Included from <code></code></p>";

        print '</div>';
    }

    public function update_menu_capabilities(){
        global $menu;

        $amCustomizations = CusminOptions::getAdminMenuUserCustomizations();
        if (isset($amCustomizations['top'])) {
            $amCustomizations = $amCustomizations['top'];
            foreach ($amCustomizations as $cIndex => $cItem) {
                //print_r($cItem);
                if(isset($cItem['cap']) && isset($cItem['url'])){
                    foreach($menu as $omiIndex => $omi){
                        //2 index, 1 cap
                        if($omi[2] == $cItem['url'] && $omi[1] !== $cItem['cap']){
                           // echo $omi[2].",". $omi[1].",".$cItem['cap']."|";
                            $menu[$omiIndex][1] = $cItem['cap'];
                            break;
                        }
                    }
                }
            }
        }
        //print_r($menu);die;
    }

    public function add_admin_body_class($classes)
    {
        if (!is_user_logged_in()) {
            return $classes;
        }
        if (is_array($classes)) { //on public pages
            $classes[] = 'cusmin';
        } else {//on admin/login pages
            $classes .= " cusmin";
        }
        return $classes;
    }

    public function admin_bar_menu()
    {
        $this->options->setAdminBar();
        if($this->is_ajax_call_get_public_admin_bar()){
            return false;
        }
        if(is_user_logged_in()){
            $this->options->adminBarApplyUserCustomizations();
        }
    }

    /**
     * Creates the options page
     *
     * @since        1.0.0
     * @return        void
     */
    public function options_page()
    {
        $op = new Cusmin_OptionsPage($this->plugin_name, $this->version);
        $op->render();

    } // options_page()

    public function admin_footer()
    {
        $this->error_check();
        $this->applyJS();

        $this->prepareApplier();
        if (self::$applier->setting_135()) {
            echo $this->wrapGACode(self::$applier->setting_135());
        }
    }

    protected function wrapGACode($code){
        return
            "<script type='text/javascript'>(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){".
            "(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),".
            "m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)".
            "})(window,document,'script','//www.google-analytics.com/analytics.js','ga');".
            "ga('create', '".$code."', 'auto');".
            "ga('send', 'pageview');</script>";
    }

    public function admin_init()
    {
        $this->remove_post_type_support();
        $this->remove_user_profile_color_scheme();
    }

    public function remove_post_type_support()
    {
        //global $_wp_post_type_features;
        //TODO: Print an array of types to user UI so user can check them, use the configuration here to remove them
        // print_r($_wp_post_type_features);die;
        /*remove_post_type_support( 'post', 'excerpt' );
        remove_post_type_support( 'post', 'title' );
        remove_post_type_support( 'post', 'editor' );
        remove_post_type_support( 'post', 'author' );
        remove_post_type_support( 'post', 'comments' );
        remove_post_type_support( 'post', 'thumbnail' );
        remove_post_type_support( 'post', 'trackbacks' );
        remove_post_type_support( 'post', 'custom-fields' );
        remove_post_type_support( 'post', 'post-formats' );*/
    }

    protected function remove_user_profile_color_scheme(){
        if(self::$applier->setting_147()){
            remove_action( 'admin_color_scheme_picker', 'admin_color_scheme_picker' );
        }
    }

    public function register_settings()
    {
        register_setting('cusmin', 'cusmin');

        //TODO: 2.0 version. Disable dashboard widgets drag and drop ordering. add this option to the dashboard
        //wp_deregister_script('postbox');

        $this->loadCustomizations();
    }

    public function on_admin_head()
    {
        $this->applyCustomizations();
        $this->applyCustomCSS();
        if ($this->isCusminSettingsPage()) {
            $this->on_cusmin_settings_page_head();
        }
        echo '<script type="text/javascript">';
        echo 'window.cusminPublic = {logout:"' . wp_logout_url() . '"}';
        echo '</script>';

        $this->prepareApplier();
        if($url = self::$applier->setting_175()){
            echo "<link rel=\"icon\" href=\"$url\">";
        }
    }

    public function on_login_init()
    {
       /* register_post_type( 'acme_product',
            array(
                'labels' => array(
                    'name' => __( 'Products' ),
                    'singular_name' => __( 'Product' )
                ),
                'public' => true,
                'has_archive' => true,
            )
        );*/

        if (!$this->isLoginPage()) {
            return false;
        }
        //do stuff
        $this->loadLoginCustomizations();
    }

    public function on_login_head()
    {
        $this->enqueueLoginScripts();
    }

    public function on_login_footer(){
        $this->prepareApplier();

        if (self::$applier->setting_136()) {
            echo $this->wrapGACode(self::$applier->setting_136());
        }else{
            $customizations = $this->options->getPublicCustomizations();
            if(!empty($customizations['php'])){
                $app = new CusminApplier($customizations['php']);
                echo $this->wrapGACode($app->setting_136());
            }
        }
    }

    public function isCusminSettingsPage()
    {
        $screen = get_current_screen();
        return $screen->id === CusminAdmin::CUSMIN_PAGE_NAME;
    }

    public function isLoginPage()
    {
        return in_array($GLOBALS['pagenow'], array('wp-login.php', 'wp-register.php'));
    }

    public function on_cusmin_settings_page_head()
    {
        if(isset($_GET['debug']) && $_GET['debug'] === 'true'){
            ?>
            <script type="text/javascript">
            window.addEventListener("error", function (e) {
                    if (cusmin.config.debug) {
                        const separator = '______________________';
                        let data = separator + '\n\n  Cusmin exception(' + e.error.name  + ')\n' + separator;
                        data += '\n' + e.error.message ;
                        data += '\n' + e.filename;
                        data += '\n' + e.lineno +':' + e.colno;
                        data += '\n' + JSON.stringify(e.error.stack);
                        data += '\n' + separator + '\n';
                        clog.print('<p style="color: #f00">' + data + '</p>');
                    }
                return true;
            })
            </script>
            <?php
        }else if(CUSMIN_SCRIPT_TYPE === 'file') {
            ?>
            <script type="text/javascript">
            //Use this to test if Cusmin script is reachable
            var exampleCusminScriptUrl = '<?php echo plugin_dir_url(__DIR__) . 'public/cusmin-script.php?ctx=admin&ver=' . rand(1000, 9999); ?>';
            try {
                jQuery.ajax({
                    url: exampleCusminScriptUrl,
                    error: function(e, a, message){
                        var errMessage = 'Unable to access Cusmin script file because of an error <b>' + e.status + ': ' + message + '</b>.<br/>This file is required for showing customizations, please check if you can resolve the access issue on your site for this file (click to see the problem): <br/><br/><a href="' + exampleCusminScriptUrl + '" target="_blank"><b>' + exampleCusminScriptUrl + '</b></a><br/><br/>';
                        errMessage += 'Please check if you have some security plugin installed, or security rules that block direct access to PHP scripts in plugins.<br/>As an alternative solution, please enable loading Cusmin scripts via URL by adding this to your <b>wp-config.php</b>';
                        errMessage += '<br/><br/><b>define(\'CUSMIN_SCRIPT_TYPE\', \'url\');</b>';
                        jQuery('#wpbody-content').prepend('<p style="color: red;border: 1px solid red;padding: 10px;border-radius: 5px;">' + errMessage + '</p>');
                    }
                });
            }catch (e) {console.log('error trying to get example cusmin script', e);}
            </script>
            <?php
        }
        //$configs = CusminOptions::getAllConfigurations();
        //$this->configurations = $configs;
        // print_r($this->options->getAllConfigurations('default'));
    }

    public function prepareApplier(){
        if(!self::$applier){
            $customizations = $this->options->getCurrentUserCustomizations();
            $this->php = $customizations['php'];
            self::$applier = new CusminApplier($this->php);
        }
    }

    public function prepareLoginApplier(){
        if(!self::$applier){
            $customizations = $this->options->getLoginCustomizations();
            $this->php = $customizations['php'];
            self::$applier = new CusminApplier($this->php);
        }
    }

    public function loadCustomizations()
    {
        $customizations = $this->options->getCurrentUserCustomizations();
        $this->css = $customizations['css'];
        $this->js = $customizations['js'];
        $this->php = $customizations['php'];
        self::$applier = new CusminApplier($this->php);
        $this->customCSS = $customizations['custom_css'];
        $this->js .= $customizations['custom_js'];
    }

    public function loadLoginCustomizations()
    {
        $customizations = $this->options->getLoginCustomizations();
        $this->loginCSS = $customizations['css'];
        $this->loginJS = $customizations['js'];
    }

    public function applyCustomizations()
    {
        $this->options->preserveOriginalMenu();

        if (self::$applier && self::$applier->setting_59()) {
            //TODO: Test profile button on non users
            if (self::$applier->setting_89()) {
                remove_menu_page('profile.php');
            }
            $this->options->adminMenuApplyTop();
            $this->options->adminMenuApplySub();
            if (self::$applier->setting_60()) {
                $this->options->adminMenuRemoveItems();
            }
        }

        //Hide content only if using JS. If using CSS, it will be automatically hidden
        //TODO: Test and improve (sync with cusmin-script.php)
        //check here if there are scripts

        //if($this->js !='') {
        $skipPreHidding = false;

        if(!empty($_GET['page'])){
            if($_GET['page'] == 'postie-settings'){
                $skipPreHidding = true;
            }
        }

        if ($this->options->getAdminJSCustomizations() != '' && !$skipPreHidding) {
            ?>
            <script type="text/javascript">
                document.write('<style type="text/css">html{visibility:hidden;}</style>');
            </script>
            <?php
        }

        $this->printCSSScript();
        $this->applyPHP();
    }

    public function enqueueLoginScripts()
    {
        //TODO: Test if it's better to use scripts here or in footer
        $this->printCSSScript(true);
        $this->printJSScript(true);

        //original WP implementation
        //$this->enqueueLoginStyle();
        //$this->enqueueLoginJS();

        $this->prepareLoginApplier();
        if(self::$applier && self::$applier->setting_174()){
            if($url = self::$applier->setting_174()){
                echo "<link rel=\"icon\" href=\"$url\">";
            }
        }
    }

    private function printJSScript($isLogin = false)
    {
        $ctx = $isLogin ? 'login' : 'admin';
        if($isLogin && !CusminOptions::isLoginJSSet()) return false;

        if(CUSMIN_SCRIPT_TYPE === 'url') {
            echo '<script src="' . get_site_url() . '?cusmin-script='  . $ctx . '.js&ver=' . CusminOptions::getId() . get_current_user_id() . '"  type="text/javascript" ></script>';
        }else{
            echo '<script src="' . plugin_dir_url(__FILE__) . '../public/cusmin-script.php?ctx=' . $ctx . '&type=js&ver=' . CusminOptions::getId() . get_current_user_id() . '"  type="text/javascript" ></script>';
        }
    }

    private function printCSSScript($isLogin = false)
    {
        $ctx = $isLogin ? 'login' : 'admin';
        if($isLogin && !CusminOptions::isLoginCSSSet()) return false;

        if(CUSMIN_SCRIPT_TYPE === 'url') {
            echo '<link href="' . get_site_url() . '?cusmin-script=' . $ctx . '.css&ver=' . CusminOptions::getId() . get_current_user_id() . '" rel="stylesheet" type="text/css" media="all" />';
        }else {
            echo '<link href="' . plugin_dir_url(__FILE__) . '../public/cusmin-script.php?ctx=' . $ctx . '&ver=' . CusminOptions::getId() . get_current_user_id() . '" rel="stylesheet" type="text/css" media="all" />';
        }
    }

    /*private function applyCSS()
    {
        //Used on all admin pages
        //wp_enqueue_style('cusmin', plugin_dir_url(__FILE__) . '../public/cusmin-script.php?ctx=login', array(), CusminOptions::getId(), true);

      //  echo 'dddd<style type="text/css">' . $this->css . '</style>';
    }*/

    /*    private function enqueueLoginStyle()
        {

       //     wp_enqueue_style('cusmin', plugin_dir_url(__FILE__) . '../public/cusmin-script.php?ctx=login', array(), CusminOptions::getId());

            //$bundle = $this->loginCSS;
            //echo '<style type="text/css">' . $bundle . '</style>';

        }

        private function enqueueLoginJS()
        {
    //        wp_enqueue_style($this->cusmin, plugin_dir_url(__FILE__) . 'cusmin-script.php', array(), CusminOptions::getId(), 'all');
            wp_enqueue_script('cusmin', plugin_dir_url(__FILE__) . '../public/cusmin-script.php?ctx=login&type=js', array('jquery'), CusminOptions::getId(), true);

          //  echo '<!--cusmin login js--><script type="text/javascript">' . self::wrapJS($this->loginJS) . '</script>';
        }*/

    private function applyJS()
    {
        //$bundle = $this->js;
        /*  $bundle=self::$applier->setting_11();
          $bundle.=self::$applier->setting_69();*/

        // echo '<!--cusmin js--><script type="text/javascript">' . self::wrapJS($bundle) . '</script>';

        $this->printJSScript();
    }

    //TODO: Move to utilities function
    public static function wrapJS($js)
    {
        if (!$js) {
            return '';
        }
        return '(function($){$(function(){try{' . $js . '}catch(e){console.log("Cusmin exception:", e);}});})(jQuery);';
    }

    private function applyPHP()
    {
        if(self::$applier){
            self::$applier->apply();
        }
    }

    //TODO: Create special class for customizing PHP settings
    public function change_title($admin_title, $title)
    {
        return self::$applier->setting_12($admin_title, $title);
    }

    private function applyCustomCSS()
    {
        echo '<style type="text/css">' . $this->customCSS . '</style>';
    }

    public function remove_notices(){
        if (self::$applier && self::$applier->setting_150()) {
            remove_all_actions( 'admin_notices', 99999);
            //Add back Cusmin notifications
            add_action( 'admin_notices', array(&$this,'notices'), 99999);
        }
    }

    public function notices(){
        $userNotices = $this->options->getCurrentUserNotices();
        foreach($userNotices as $key => $notice){
            $class = 'notice cusmin-notice notice-'.($notice['message-type'] == 'error'?'error':'success').' is-dismissible';
            $message = __( $notice['message'], 'cusmin' );
            $onClick = 'onclick="window.cusminPublic.dismissNotice(\''.$key.'\');"';
            printf( '<div class="%1$s" %2$s>%3$s</div>', $class, $onClick, $message );
        }
    }

    public function apply_meta_boxes($type){
        $boxes = $this->options->getCurrentUserHiddenMetaboxes();
        if(isset($boxes[$type]) && is_array($boxes[$type])){
            $typeBoxes = $boxes[$type];
            foreach($typeBoxes as $box){
                remove_meta_box( $box, $type, 'normal' );
                remove_meta_box( $box, $type, 'side' );
                remove_meta_box( $box, $type, 'advanced' );
            }
        }
    }

    public function ajax_list_meta_boxes()
    {
        ini_set('display_errors', 0);

        if (!$this->is_ajax_call_get_meta_boxes()) {
            return false;
        }

        $boxes = array();
        global $wp_meta_boxes;

        if(is_array($wp_meta_boxes)){
            foreach($wp_meta_boxes as $wp_boxes) {
                if($wp_boxes){
                    foreach($wp_boxes as $inner_boxes) {
                        if($inner_boxes) {
                            foreach($inner_boxes as $inner2_boxes){
                                if($inner2_boxes){
                                    foreach($inner2_boxes as $box){
                                        if(is_array($boxes) && is_array($box)) {
                                            $boxes[$box['id']] = $box['title'];
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        print_r(json_encode($boxes));die;
    }

    public function ajax_dashboard_list_widgets()
    {
        if (!$this->is_ajax_call_get_dashboard_widgets()) {
            return false;
        }
        //do stuff
        global $wp_meta_boxes;

        $widgets = array();
        if (isset($wp_meta_boxes['dashboard'])) {
            //example: [dashboard][normal][core] or [dashboard][side][core]
            foreach ((array)$wp_meta_boxes['dashboard'] as $key => $top) { //e.g. key => normal
                foreach((array) $top as $subkey => $widgs){ //e.g. subkey => core
                    foreach((array)$widgs as $wkey =>  $w){
                        $widgets[$wkey] = array(
                            'title' => $w['title'],
                            'place' => $key,
                            'sub' => $subkey
                        );
                    }
                }
            }
            echo json_encode($widgets);
            die;
        }
    }

    public function manage_posts_columns($columns)
    {
        if ($this->is_ajax_call_get_columns()) {
            echo '<posts-columns-list>' . json_encode($columns) . '</posts-columns-list>';
            die;
        }
        return $this->options->getColumnsApplier()->postsColumns($columns);
    }

    public function bulk_actions_posts($actions)
    {
        return $this->options->getColumnsApplier()->bulkActionsPosts($actions);
    }

    public function bulk_actions_pages($actions)
    {
        return $this->options->getColumnsApplier()->bulkActionsPages($actions);
    }

    public function bulk_actions_users($actions)
    {
        return $this->options->getColumnsApplier()->bulkActionsUsers($actions);
    }

    public function bulk_actions_plugins($actions)
    {
        return $this->options->getColumnsApplier()->bulkActionsPlugins($actions);
    }

    public function bulk_actions_comments($actions)
    {
        return $this->options->getColumnsApplier()->bulkActionsComments($actions);
    }

    public function rename_collapse_menu($translated, $original, $domain){
        if($original == 'Collapse menu'){

            if (self::$applier && self::$applier->setting_145()) {
                return self::$applier->setting_145();
            }

        }
        return $translated;
    }

    public function access_denied_page(){
        $this->prepareApplier();
        if (self::$applier) {
            $rules = self::$applier->setting_154();
            if(!empty($rules)){
                $screen = get_current_screen();
                if(is_array($rules) && array_key_exists($screen->id, $rules)){
                    wp_die( __( 'Sorry, you are not allowed to access this page.' ).' (c)' );
                }
            }
        }
    }

    public function hide_plugins(){

        if (self::$applier) {
            $settingValue = self::$applier->setting_151();
            if(!empty($settingValue)){
                global $wp_list_table;
                $hidearr = self::$applier->setting_151();
                $myplugins = $wp_list_table->items;
                //print_r($hidearr);die;
                //print_r($myplugins);die;
                foreach ($myplugins as $key => $p) {
                    $slug = !empty($p['slug'])?$p['slug']:'';
                    $name = !empty($p['Title'])?$p['Title']:'';

                    if ($slug && array_key_exists($slug,$hidearr)) {
                        unset($wp_list_table->items[$key]);
                    }else if($name && in_array($name, $hidearr, true)){
                        unset($wp_list_table->items[$key]);
                    }
                }
            }
        }
    }

    public function do_meta_boxes(){
        global $wp_meta_boxes;
        print_r($wp_meta_boxes);die;
    }

    //add remove dashboard widgets
    public function dashboard_page_setup()
    {
        if ($this->is_ajax_call_get_dashboard_widgets()) {
            return false;
        } else if (get_current_screen()->id != 'dashboard') {
            return false;
        }
        //$this->options->preserveDashboardWidgetsList();

        $widgets = self::$applier->setting_29();
        $myWidgets = self::$applier->setting_72();

        $dwApplier = new CusminDashboardWidgetsApplier($widgets, $myWidgets);
        $dwApplier->applyCustomWidgets();
        $dwApplier->hideOriginalWidgets();
    }

    //After any post is saved, hook
   /* public function after_post_is_saved($post_id, $post, $isUpdate){

        // If this is a revision, get real post ID
        if ( $parent_id = wp_is_post_revision( $post_id ) )
            $post_id = $parent_id;


        if(get_post_type($post_id) == 'post' && $isUpdate){

            // unhook this function so it doesn't loop infinitely
            remove_action( 'save_post', array(&$this,'after_post_is_saved') );

            //todo - update the post, which calls save_post again


            // re-hook this function
            add_action( 'save_post', array(&$this,'after_post_is_saved'), 99999, 3 );
        }
    }*/

    /**
     * After new user is created/registersd
     * @param $userID
     */
    public function user_registered($userID){

        //Apply default dashboard widgets ordering if applicable
        $user = get_user_by('id', $userID);

        if($user){
            $configs = CusminOptions::getUserConfigurations($user);
            foreach((array) $configs as $c){
                if(!empty($c[CusminOptions::DASHBOARD_WIDGETS_USERNAME])){
                    $username = $c[CusminOptions::DASHBOARD_WIDGETS_USERNAME];
                    $refUser = get_user_by('login', $username);
                    if($refUser){
                        $userDashboardOrdering = get_user_meta( $refUser->ID, 'meta-box-order_dashboard', true );
                        if($userDashboardOrdering){
                            update_user_meta( $userID, 'meta-box-order_dashboard', $userDashboardOrdering );
                            break;
                        }
                    }
                }
            }
            //print_r($configs);die;
        }
    }

    private function is_ajax_call_get_dashboard_widgets()
    {
        if (isset($_GET['cusmin-action'])) {
            if ($_GET['cusmin-action'] == 'cusmin-list-dashboard-widgets') {
                return true;
            }
        }
        return false;
    }

    private function is_ajax_call_get_public_admin_bar(){
        if (isset($_GET['cusmin-action'])) {
            if ($_GET['cusmin-action'] == 'cusmin-get-public-admin-bar') {
                return true;
            }
        }
        return false;
    }

    private function is_ajax_call_get_meta_boxes()
    {
        if (isset($_GET['cusmin-action'])) {
            if ($_GET['cusmin-action'] == 'cusmin-list-metaboxes') {
                return true;
            }
        }
        return false;
    }

    private function is_ajax_call_get_columns()
    {
        if (isset($_GET['cusmin-action'])) {
            if ($_GET['cusmin-action'] == 'cusmin-list-columns') {
                return true;
            }
        }
        return false;
    }

    function error_check()
    {
        ?>
        <script type="text/javascript">
            function CusminErrorOtherPages(msg, url, line, column, error) {
                var cusmin_error_details = "___________________________________________________\n";
                cusmin_error_details += '\n' + msg + '\nsource:' + url + '\nline:' + line + ':' + column + '\n';
                document.getElementsByTagName('html')[0].style.visibility = "visible";
                if (typeof window.console === "object") {
                    console.log("%c___________________________________________________", 'color: #f00');
                    console.log("%c Cusmin caught a JavaScript error on your site:", 'color: #f00');
                    console.log('%c' + cusmin_error_details, 'color: #f00');
                    console.log('%c' + error.stack, 'color: #f00');
                }
            }
            window.onerror = function (msg, url, line, column, error) {
                window.onload = function () {
                    CusminErrorOtherPages(msg, url, line, column, error);
                }
                return true;
            };
            document.getElementsByTagName('html')[0].style.visibility = "visible";
        </script>
        <?php
    }
}