<?php

class CusminABApplier
{
    private $parentNodes;
    private $childNodes;
    private $co;
    const ADMIN_BAR_OPTION_ID = 70;
    const ADMIN_BAR_FRONT_END_ID = 134;

    public function __construct(CusminOptions $co)
    {
        $this->co = $co;
        $this->loadOriginalNodes();
    }

    public function getOriginalParents()
    {
        return $this->parentNodes;
    }

    public function getOriginalChildren()
    {
        return $this->childNodes;
    }

    public function applyCustomizations($customizations)
    {
        $abCustomizations = $this->getABCustomizations($customizations);

        //Apply front end customizations
        if(!is_admin()){
            $this->applyFrontEndCustomizations($this->getABFrontEndCustomizations($customizations));
        }

        if (isset($abCustomizations['parent'])) {
            $this->applyOneTypeOfABCustomizations($abCustomizations['parent'], true);
        }
        if (isset($abCustomizations['child'])) {
            $this->applyOneTypeOfABCustomizations($abCustomizations['child']);
        }
    }

    public static function getABCustomizations($customizations)
    {
        $abOptions = null;
        if (isset($customizations['php'][self::ADMIN_BAR_OPTION_ID])) {
            $abOptions = $customizations['php'][self::ADMIN_BAR_OPTION_ID];
        }
        return $abOptions;
    }

    public static function getABFrontEndCustomizations($customizations)
    {
        $abOptions = null;

        if (isset($customizations['php'][self::ADMIN_BAR_FRONT_END_ID])) {
            $abOptions = $customizations['php'][self::ADMIN_BAR_FRONT_END_ID];
        }
        return $abOptions;
    }

    //We use only public customizations
    private static function applyFrontEndCustomizations($customizations)
    {
        global $wp_admin_bar;
        $nodes = $wp_admin_bar->get_nodes();
        if ($customizations) {
            foreach ((array) $customizations as $id) {
                foreach ($nodes as $node) {
                    if($node->id == $id){
                        $wp_admin_bar->remove_node($node->id);
                    }
                }
            }
        }
    }

    private function applyOneTypeOfABCustomizations($customizations, $parentContext = false)
    {
        //TODO: In JS instead of using full urls, try adding url placeholder
        global $wp_admin_bar;
        $nodes = $wp_admin_bar->get_nodes();

        $foundIds = array();

        //print_r($wp_admin_bar);die;

        //Apply nodes customizations
        if (isset($customizations)) {
            foreach ($customizations as $index => $c) {
                $found = false;
                foreach ($nodes as $node) {
                    if ($this->getNodeCondition($node, $parentContext, $c)) {
                        $found = true;
                        $foundIds[] = $node->id;
                        if (isset($c['hidden'])) {
                            //handle hidden items
                            $wp_admin_bar->remove_node($node->id);
                        } else {
                            //handle updated original items
                            if (isset($c['title'])) {
                                $title = $c['title'];
                                if ($node->id == 'new-content') {
                                    $node->title = preg_replace('#(<span class="ab-label".*?>).*?(</span>)#', '$1'.$title.'$2', $node->title);
                                }else if ($node->id == 'updates') {
                                    try{
                                        $matches = null;
                                        preg_match('#(<span class="ab-label".*?>).*?(</span>)#', $node->title, $matches);
                                        $count = $matches[0];
                                        $text = $count.' '.$title;
                                        //TODO: Replace HTML title as well
                                        $newTitle = preg_replace('#(<span class="ab-label".*?>).*?(</span>)#','$1'.$text.'$2' , $node->title);
                                        $newTitle = preg_replace('#(<span class="screen-reader-text".*?>).*?(</span>)#', '$1'.$text.'$2', $newTitle);
                                        $node->title = $newTitle;
                                    }catch (\Exception $e){
                                        error_log($e);
                                    }
                                }else if ($node->id == 'comments') {
                                    try{
                                        $matches = null;
                                        preg_match('#(<span id="ab-awaiting-mod".*?>).*?(</span>)#', $node->title, $matches);
                                        $count = $matches[0];
                                        $text = $count.' '.$title;
                                        //TODO: Replace HTML title as well
                                        $newTitle = preg_replace('#(<span id="ab-awaiting-mod".*?>).*?(</span>)#','$1'.$text.'$2' , $node->title);
                                        $newTitle = preg_replace('#(<span class="screen-reader-text".*?>).*?(</span>)#', '$1'.$text.'$2', $newTitle);
                                        $node->title = $newTitle;
                                    }catch (\Exception $e){
                                        error_log($e);
                                    }
                                }else if ($node->id == 'user-info') {
                                    //skip changes
                                }

                                //CHILD ITEMS
                                else if($node->id == 'my-account'){
                                    try{
                                        $parts = explode(",",$node->title, 2);
                                        $node->title = $title.','.$parts[1];
                                    }catch (\Exception $e){
                                        error_log($e);
                                    }
                                } else {
                                    $node->title = $title;
                                }
                            }
                            //icon and icon color

                            if (isset($c['icon']) || isset($c['color'])) {
                                //prepare
                                if(!($node->meta)){
                                    $node->meta = array();
                                }
                                if(!isset($node->meta['class'])){
                                    $node->meta['class'] = '';
                                }
                                $node->meta['class'] .= ' cusmin-ab-icon';
                            }
                            if (isset($c['icon'])) {
                                //Used to mark it for JS script
                                $node->meta['class'] .= ' '. $c['icon'];
                            }
                            if (isset($c['color'])) {
                                $node->meta['class'] .= ' color-'. $this->hexColorNoHash($c['color']);
                            }
                            if (isset($c['colorHover'])) {
                                $node->meta['class'] .= ' color-hover-'. $this->hexColorNoHash($c['colorHover']);
                            }
                            if ($parentContext && ($node->id == 'site-name')) {
                                //skip linek update for parent nodes
                            } else if(!$parentContext && ($node->id == 'logout')){
                                //skip link update for child nodes
                            } else {
                                if (isset($c['link'])) {
                                    $node->href = $c['link'];
                                }
                            }

                            if (isset($c['target'])){
                                //prepare
                                if(!($node->meta)){
                                    $node->meta = array();
                                }
                                if(!isset($node->meta['class'])){
                                    $node->meta['class'] = '';
                                }
                                $node->meta['class'] .= ' cusmin-target-'.$c['target'];
                            }

                            $wp_admin_bar->remove_node($node->id);
                            $wp_admin_bar->add_node($node);
                            //print_r($node);
                        }
                        break;
                    }
                }

                //handle custom buttons
                if (!$found && isset($c['custom'])) {
                    if (!isset($c['hidden'])) {
                        $iconCls = isset($c['icon']) ? ' cusmin-ab-icon '.$c['icon'] : '';
                        $colorCls = isset($c['color']) ? ' color-'.$this->hexColorNoHash($c['color']) : '';
                        $colorHoverCls = isset($c['colorHover']) ? ' color-hover-'.$this->hexColorNoHash($c['colorHover']) : '';

                        $colorTxtCls = isset($c['colorTxt']) ? ' color-txt-'.$this->hexColorNoHash($c['colorTxt']) : '';
                        $colorTxtHoverCls = isset($c['colorTxtHover']) ? ' color-txt-hover-'.$this->hexColorNoHash($c['colorTxtHover']) : '';
                        $colorBgCls = isset($c['colorBg']) ? ' color-bg-'.$this->hexColorNoHash($c['colorBg']) : '';
                        $colorBgHoverCls = isset($c['colorBgHover']) ? ' color-bg-hover-'.$this->hexColorNoHash($c['colorBgHover']) : '';
                        $targetCls = isset($c['target']) ? ' cusmin-target-'.$c['target'] : '';

                        $meta = array(
                            'class'=>$iconCls.$colorCls.$colorHoverCls.$colorTxtCls.$colorTxtHoverCls.$colorBgCls.$colorBgHoverCls.$targetCls
                        );
                        $wp_admin_bar->add_node(array(
                            'id' => isset($c['id']) ? $c['id'] : '',
                            'parent' => isset($c['parent']) ? $c['parent'] : '',
                            'title' => isset($c['title']) ? $c['title'] : '',
                            'href' => isset($c['link']) ? $c['link'] : '',
                            'meta' => $meta
                        ));
                    }
                }
            }
        }

        //print_r($foundIds);

        //apply later added nodes from outside
        foreach ($nodes as $node) {
            if ($this->getNodeCondition($node, $parentContext) && !in_array($node->id, $foundIds)) {
                $foundIds[] = $node->id;
                $wp_admin_bar->remove_node($node->id);
                $wp_admin_bar->add_node($node);
            }
        }
        //print_r($wp_admin_bar); die;
    }

    //TODO: Duplicate method, the same is in cusmin options
    private static function hexColorNoHash($color){
        return preg_replace("/[^a-zA-Z0-9]+/", "", $color);
    }

    private function getNodeCondition($node, $parentContext = false, $c = null)
    {
        $typeCondition = $parentContext ?
            $node->parent == '' :
            $node->parent != '';
        return $c ?
            $typeCondition && $node->id == $c['id'] :
            $typeCondition;
    }

    private function loadOriginalNodes()
    {
        global $wp_admin_bar;

        $nodes = $wp_admin_bar->get_nodes();
        $parentNodes = array();
        $childNodes = array();
        $parentCounter = 0;
        $childCounter = 0;
        if ($nodes) {
            foreach ($nodes as $node) {
                if ($node->parent == '') {
                    $parentNodes[$parentCounter] = $node;
                    $parentCounter++;
                } else {
                    $childNodes[$childCounter] = $node;
                    $childCounter++;
                }
            }
        }
        $this->parentNodes = $parentNodes;
        $this->childNodes = $childNodes;
    }
}