<?php

/**
 * Created by PhpStorm.
 * User: goran
 * Date: 31/01/16
 * Time: 10:09
 */
class CusminApplier
{
    private $options;
    public function __construct($options = array()) {
        $this->options = $options;
    }

    /*
     * Apply other PHP settings
     */
    public function apply(){

    }

    /**
     * Used for boolean options
     * @param $no
     * @return bool
     */
    private function isOption($no){
        return isset($this->options[$no]) and $this->options[$no] == 1;
    }

    private function isTextOption($no){
        return isset($this->options[$no]) and $this->options[$no] != '';
    }

    /**
     * @return bool
     * @deprecated Option not needed
     */
    public function setting_8()
    {
        return $this->isOption(8);
    }

    public function setting_9()
    {
        return !$this->isOption(9);
    }

    public function setting_11(){
        $value = '';
        if($this->isTextOption(11)){
            $value = $this->options[11];
            if($value == '%SWITCH%'){
                $value = get_bloginfo('wpurl');
                if(!is_admin()){
                    $value.='/wp-admin';
                }
            }
            if($value != ''){
                $value = '$("li#wp-admin-bar-wp-logo a.ab-item").attr(\'href\',\''.$value.'\');';
            }
        }
        return $value;
    }

    public function setting_12($admin_title, $title)
    {
        if($this->isTextOption(12)){
            $blog = get_bloginfo('name');
            $page = $title;
            $customTitle = $this->options[12];
            $customTitle = str_replace('%BLOG%',$blog, $customTitle);
            $customTitle = str_replace('%PAGE%',$page,$customTitle);
            return $customTitle;
        } else {
            return $admin_title;
        }
    }

    public function setting_19(){
        if(!$this->isOption(19)){
            return;
        }
        if ( ! function_exists( 'c2c_no_update_nag' ) ) :
            function c2c_no_update_nag() {
                remove_action( 'admin_notices', 'update_nag', 3 );
            }
        endif;
        c2c_no_update_nag();
        return '$("#update-nag,.update-nag").css("display","none");';
    }

    public function setting_29(){
        $widgetSlugs = array();
        if($this->isTextOption(29)){
            $widgetSlugs = $this->options[29];
        }
        return $widgetSlugs;
    }
    //is admin menu customizations applied
    public function setting_59()
    {
        return $this->isOption(59);
    }
    //admin menu hide completely
    public function setting_60()
    {
        return $this->isOption(60);
    }
    public function setting_69()
    {
        $wpurl = get_bloginfo('wpurl');
        if($this->isTextOption(69)){
            $url = $this->options[69];
            return
                'var href = "'.$url.'";'.
                'href = href.replace("%BLOG%", "'.$wpurl.'");'.
                '$("#sidebar_adminmenu_logo").attr(\'onclick\',\'window.open(\"\'+ href+ \'\");\');'.
                '$("#sidebar_adminmenu_logo").attr(\'title\',href);';
        }else{
            return
                'href = "'.$wpurl.'";'.
                '$("#sidebar_adminmenu_logo").attr(\'onclick\',\'window.open("\'+ href+ \'");\');'.
                '$("#sidebar_adminmenu_logo").attr(\'title\',href);';
        }
    }

    public function setting_72(){
        $widgetSlugs = array();
        if($this->isTextOption(72)){
            $widgetSlugs = $this->options[72];
        }
        return $widgetSlugs;
    }

    public function setting_89(){
        return $this->isOption(89);
    }

    public function setting_134(){
        return isset($this->options[134])? $this->options[134]:null;
    }

    //admin ga
    public function setting_135(){
        return isset($this->options[135])? $this->options[135]:null;
    }

    //login ga
    public function setting_136(){
        return isset($this->options[136])? $this->options[136]:null;
    }

    //public ga
    public function setting_137(){
        return isset($this->options[137])? $this->options[137]:null;
    }

    public function setting_138(){
        return $this->isOption(138);
    }

    public function setting_145(){
        if($this->isTextOption(145)){
            return $this->options[145];
        }
        return '';
    }

    public function setting_147(){
        return $this->isOption(147);
    }

    /**
     * @return string 'all', 'first', 'last'
     */
    public function setting_149(){
        $num = 149;
        if(isset($this->options[$num])){
            $val = $this->options[$num];
            if($val == 1){
                return 'first';
            }else if($val == 2){
                return 'last';
            }
        }
        return 'all';
    }

    public function setting_150(){
        return $this->isOption(150);
    }

    public function setting_151(){
        if(isset($this->options[151])){
            return $this->options[151];
        }
    }

    public function setting_154(){
        if(isset($this->options[154])){
            return $this->options[154];
        }
    }

    public function setting_156(){
        if(isset($this->options[156])){
            return $this->options[156];
        }
    }

    public function setting_157(){
        if(isset($this->options[157])){
            return $this->options[157];
        }
    }

    public function setting_158(){
        if(isset($this->options[158])){
            return $this->options[158];
        }
    }

    public function setting_174(){
        if(isset($this->options[174])){
            return $this->options[174];
        }
    }

    public function setting_175(){
        if(isset($this->options[175])){
            return $this->options[175];
        }
    }

    public function setting_176(){
        if(isset($this->options[176])){
            return $this->options[176];
        }
    }

    public function setting_177(){
        if(isset($this->options[177])){
            return $this->options[177];
        }
    }

    public function setting_178(){
        if(isset($this->options[178])){
            return $this->options[178];
        }
    }
}