<?php

class CusminUpdater
{
    private $cuc;

    public function __construct($cuc){

        if(!is_admin()){
            return false;
        }
        $this->cuc = $cuc;
        $this->registerCallbacks();
        $this->registerHooks();

        add_filter('plugin_row_meta', array($this,'plugin_links'), 10, 2);
    }

    private function registerHooks(){
        add_action("after_plugin_row_cusmin/cusmin.php", array($this, 'after_row'), 10, 3 );
        add_action("in_plugin_update_message-cusmin/cusmin.php", array($this, 'modify_message'), 10, 2 );
    }

    private function registerCallbacks(){
        $this->cuc->addResultFilter(array($this, 'check_results'));
        $this->cuc->addQueryArgFilter(array($this, 'query_args'));
    }

    public function after_row($plugin_file, $plugin_data, $status ){
        $updateError = get_transient('cusmin-update-error');
        if(!empty($updateError)){
            echo '<tr class="plugin-update-tr active" id="advanced-custom-fields-pro-update" data-slug="advanced-custom-fields-pro" data-plugin="advanced-custom-fields-pro/acf.php"><td colspan="4" class="plugin-update colspanchange"><div class="update-message notice inline notice-alt notice-error"><p>'.$updateError.'</p></div></td></tr>';
        }
    }

    public function modify_message($plugin_data, $response ){

    }

    public function check_results($pi, $result){
        if(is_array($result) && !empty($result['response']['code']) &&
            ($result['response']['code'] == 402 || $result['response']['code'] == 404)){
            set_transient('cusmin-update-error', $result['body']);
        }else{
            delete_transient('cusmin-update-error');
        }
        return $pi;
    }

    public function query_args($queryArgs){
        $revertVersion = get_transient('cusmin-revert-version');
        if($revertVersion){
            $queryArgs['revert-version'] = $revertVersion;
        }

        $queryArgs['home'] = home_url();
        $queryArgs['skey'] = '';

        delete_transient('cusmin-revert-version');

        return $queryArgs;
    }

    public function plugin_links($links, $file){
        if ( $file == 'cusmin/cusmin.php' )
        {
          /*  $v = $links[0];
            $linkUrl = wp_nonce_url( self_admin_url( 'update.php?action=upgrade-plugin&cusmin-action=revert-version&plugin=' ) . $file, 'upgrade-plugin_' . $file );
            $links[0] = '<a class="update-link cusmin-revert-version" href="'.$linkUrl.'">' . __('Revert to the previous version', 'cusmin') . '</a>';
            array_unshift($links , $v);*/
        }
        return $links;
    }
}

