<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       http://example.com
 * @since      1.0.0
 *
 * @package    Cusmin
 * @subpackage Cusmin/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Cusmin
 * @subpackage Cusmin/includes
 * @author     Your Name <email@example.com>
 */


class Cusmin {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Cusmin_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $cusmin    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 * @param $cuc Cusmin Update Checker
	 */
	public function __construct($cuc) {

		$this->plugin_name = 'cusmin';
		$this->load_dependencies();
		new CusminUpdater($cuc);

		$this->version = CUSMIN_PLUGIN_VERSION;
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();
	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Cusmin_Loader. Orchestrates the hooks of the plugin.
	 * - Cusmin_i18n. Defines internationalization functionality.
	 * - Cusmin_Admin. Defines all hooks for the admin area.
	 * - Cusmin_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		require_once plugin_dir_path(dirname(__FILE__)) . 'configuration.php';
		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-cusmin-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-cusmin-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-cusmin-admin.php';

		/**
		 * The class responsible for applying rules
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-cusmin-applier.php';

		/**
		 * The class responsible for admin menu
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-admin-menu-applier.php';

		/**
		 * The class responsible for admin bar
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-admin-bar-applier.php';


		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-columns-applier.php';


		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-dashboard-widgets-applier.php';


        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-agca-exporter.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-cusmin-public.php';

		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-cusmin-updater.php';

        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-ajax.php';



		$this->loader = new Cusmin_Loader();

	}


	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Cusmin_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Cusmin_i18n();
		$plugin_i18n->set_domain( $this->get_plugin_name() );

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new CusminAdmin( $this->get_plugin_name(), $this->get_version() );
        $cusmin_ajax = new CusminAjax();

        //$this->loader->add_action('init', $plugin_admin, 'cusmin_cpt', 0);

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
		$this->loader->add_action( 'login_enqueue_scripts', $plugin_admin, 'enqueue_login_scripts' );

		$this->loader->add_action( 'admin_print_footer_scripts', $plugin_admin, 'admin_footer' );
		$this->loader->add_action( 'plugin_action_links_' . $this->get_plugin_name().'/cusmin.php', $plugin_admin, 'settings_link' );
		$this->loader->add_action( 'admin_menu', 			$plugin_admin, 	'add_custom_admin_pages', 99998 );
		$this->loader->add_action( 'admin_menu', 			$plugin_admin, 	'add_menu', 99999 );

		//TODO: Test out and enable. Challenge: restricted pages
		//$this->loader->add_action( 'admin_menu', 			$plugin_admin, 	'update_menu_capabilities', 99999 );



		$this->loader->add_action( 'wp_before_admin_bar_render', 		$plugin_admin, 	'admin_bar_menu', 99999);
        $this->loader->add_action( 'admin_init', 			$plugin_admin, 	'register_settings' );
		$this->loader->add_action( 'admin_init', 			$plugin_admin, 	'admin_init' , 99999);
		$this->loader->add_action( 'admin_head', 			$plugin_admin, 	'on_admin_head', 99999);
		$this->loader->add_action( 'login_head', 			$plugin_admin, 	'on_login_head', 99999 );
		$this->loader->add_action( 'login_footer', 			$plugin_admin, 	'on_login_footer', 99999 );
		$this->loader->add_action( 'admin_notices', 		$plugin_admin, 	'notices', 99999 );
		$this->loader->add_action( 'admin_head', 			$plugin_admin, 	'remove_notices', 99999 );
		$this->loader->add_action( 'do_meta_boxes',	    	$plugin_admin, 	'dashboard_page_setup', 99999 );
		$this->loader->add_action( 'init', 					$plugin_admin, 	'on_login_init' );

		//$coption = get_option('cusmin');
		//if(!empty($coption['trialEnded'])) return false;

		$this->loader->add_action( 'do_meta_boxes',			$plugin_admin, 	'ajax_dashboard_list_widgets', 99999 );
		$this->loader->add_action( 'do_meta_boxes',			$plugin_admin, 	'ajax_list_meta_boxes', 99999 );
		$this->loader->add_action( 'do_meta_boxes',			$plugin_admin, 	'apply_meta_boxes', 99999 );

		//$this->loader->add_action( 'save_post', $plugin_admin, 'after_post_is_saved', 99999, 3  );
		$this->loader->add_action( 'user_register', $plugin_admin, 'user_registered', 99999, 1  );

		$this->loader->add_action( 'pre_current_active_plugins', $plugin_admin, 'hide_plugins', 99999, 1  );
		$this->loader->add_action( 'current_screen', $plugin_admin, 'access_denied_page', 1, 1  );

		$this->loader->add_action( 'admin_menu', $plugin_admin, 'add_custom_pages', 1, 1  );

		$this->loader->add_action( 'wp_print_scripts', $plugin_admin, 'inspect_scripts', 999999, 1 );

		// Cusmin script permalinks START
        $this->loader->add_action( 'init', $plugin_admin, 'cusmin_scripts');
        $this->loader->add_action( 'template_redirect', $plugin_admin, 'cusmin_scripts');
        //$this->loader->add_filter('request', $plugin_admin, 'cusmin_scripts');
        //$this->loader->add_action( 'upgrader_process_complete', $plugin_admin, 'plugin_upgrade_completed', 999999, 2 );
        // Cusmin script permalinks END


        $this->loader->add_action("wp_ajax_cusmin_ajax", $cusmin_ajax, "ajax");

		//Public API Post
        $this->loader->add_action( 'admin_post_nopriv_cusmin_api', $plugin_admin, 'admin_post_cusmin_api', 999999, 1 );
        $this->loader->add_action( 'admin_post_cusmin_api', $plugin_admin, 'admin_post_cusmin_api', 999999, 1 );

		$this->loader->add_filter('admin_body_class', $plugin_admin, 'add_admin_body_class');
		$this->loader->add_filter('body_class', $plugin_admin, 'add_admin_body_class');

		$this->loader->add_filter('manage_posts_columns', $plugin_admin, 'manage_posts_columns', 99999);
		$this->loader->add_filter('manage_pages_columns', $plugin_admin, 'manage_posts_columns', 99999);
		$this->loader->add_filter('manage_users_columns', $plugin_admin, 'manage_posts_columns', 99999);
		$this->loader->add_filter('manage_plugins_columns', $plugin_admin, 'manage_posts_columns', 99999);
		$this->loader->add_filter('manage_edit-comments_columns', $plugin_admin, 'manage_posts_columns', 99999);

		$this->loader->add_filter('bulk_actions-edit-post', $plugin_admin, 'bulk_actions_posts', 99999);
		$this->loader->add_filter('bulk_actions-edit-page', $plugin_admin, 'bulk_actions_pages', 99999);
		$this->loader->add_filter('bulk_actions-users', $plugin_admin, 'bulk_actions_users', 99999);
		$this->loader->add_filter('bulk_actions-plugins', $plugin_admin, 'bulk_actions_plugins', 99999);
		$this->loader->add_filter('bulk_actions-edit-comments', $plugin_admin, 'bulk_actions_comments', 99999);
		//TODO: Move to PHP class for applying PHP settings
		$this->loader->add_filter('admin_title', $plugin_admin, 'change_title', 10, 2);

		//collapse menu
		$this->loader->add_filter('gettext', $plugin_admin, 'rename_collapse_menu', 10, 3);

		$this->loader->add_filter('login_redirect', $plugin_admin, 'login_redirect', 99999, 3);



	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Cusmin_Public( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
		$this->loader->add_action( 'wp_footer', $plugin_public, 'on_footer' );
		$this->loader->add_action( 'init', 			$plugin_public, 	'public_init' );
		$this->loader->add_filter( 'show_admin_bar', $plugin_public, 'cusmin_show_admin_bar', 99999);
        $this->loader->add_action( 'admin_bar_menu', $plugin_public, 'add_admin_bar_items', 99999);
		$this->loader->add_action( 'wp_before_admin_bar_render', 		$plugin_public, 	'admin_bar_menu', 99999);
		$this->loader->add_action( 'wp_before_admin_bar_render', $plugin_public, 'ajax_public_admin_bar', 99999);
	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Cusmin_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

	public static function minifyCSS($buffer = ''){

		if(empty($buffer)){
			return $buffer;
		}
		// Remove comments
		$buffer = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $buffer);
		// Remove space after colons
		$buffer = str_replace(': ', ':', $buffer);
		// Remove whitespace
		return str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $buffer);
		/*// Enable GZip encoding.
		ob_start("ob_gzhandler");
		// Enable caching
		header('Cache-Control: public');
		// Expire in one day
		header('Expires: ' . gmdate('D, d M Y H:i:s', time() + 86400) . ' GMT');
		// Set the correct MIME type, because Apache won't set it for us
		header("Content-type: text/css");
		// Write everything out
		echo($buffer);*/
	}
}

function cusmin_debug($message) {
	if ( WP_DEBUG === true ) {
		if ( is_array($message) || is_object($message) ) {
			error_log( 'CUSMIN: '.print_r($message, true) );
		} else {
			error_log( 'CUSMIN: '.$message );
		}
	}
}

/**
 * @param $e
 */
function cusmin_exception(\Exception $e) {
	cusmin_debug($e->getMessage().' at '.$e->getFile().' ('.$e->getLine().') '.$e->getTraceAsString());
}