<?php

header("Cache-Control: max-age=2592000"); //30 days cache
header("Pragma: cache");

$cusmin_script = get_query_var( 'cusmin-script' );

//global $wp_query;
//print_r($wp_query->query_vars);die;

if(empty($cusmin_script)) {
    echo '/*cusmin_script is empty!*/';exit;
}

$parts = explode('.', $cusmin_script);
$context = $parts[0];
$type = $parts[1];

try {
    if(!class_exists('CusminOptions')) {
        echo '/*CusminOptions does not exist:'. plugin_dir_path(dirname(__FILE__)) . 'admin/includes/class-cusmin-options.php'.' */';
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/includes/class-cusmin-options.php';
    }

    if(!class_exists('CusminAdmin')) {
        echo '/*CusminAdmin does not exist:'. plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-cusmin-admin.php'.' */';
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-cusmin-admin.php';
    }

    if(CusminOptions::getTrialEnded()) return false;

    $script = '';
    $additionalJS = '';

    if ($type == "css") {
        header('Content-type: text/css');
        if ($context == 'admin') {
            if (is_user_logged_in()) {
                $script = CusminOptions::getAdminCSSCustomizations();
            }
        } else if ($context == 'login') {
            $script = CusminOptions::getLoginCSSCustomizations();
        } else {
            $script = CusminOptions::getSiteCustomCSSCustomizations();
            if (is_user_logged_in()) {//logged in user seeing public pages
                $script .= CusminOptions::getAdminCSSCustomizations();
            }
        }
        $script.=CusminOptions::getCommonCss();
    } else if ($type == "js") {
        header('Content-type: application/javascript');
        if ($context == 'admin') {
            if (is_user_logged_in()) {
                $script = CusminOptions::getAdminJSCustomizations();
                $additionalJS = CusminOptions::getAdminAdditionalScripts();
            }
        } else if ($context == 'login') {
            $script = CusminOptions::getLoginJSCustomizations();
        } else {
            $script = CusminOptions::getSiteCustomJSCustomizations();
            if (is_user_logged_in()) { //logged in user seeing public pages
                $script .= CusminOptions::getAdminJSCustomizations();
                $additionalJS = CusminOptions::getAdminAdditionalScripts();
            }
        }
        $script = CusminAdmin::wrapJS($script.$additionalJS);
    }
    //TODO: Leverage PHP file caching
    echo $script;
} catch (\Exception $e) {
    echo '/*'.$e->getCode().':'.$e->getMessage().':'.$e->getFile().':'.$e->getLine().'*/';
}
exit;